/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="rm", description="Remove one or more containers")
@Service
public class RmCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the containers to remove", required=true, multiValued=true)
    @Completion(value=ContainersNameCompleter.class)
    List<String> containers;
    @Option(name="--removeVolumes", description="Remove the container volumes", required=false, multiValued=true)
    boolean removeVolumes;
    @Option(name="--force", description="Force remove container", required=false, multiValued=true)
    boolean force;

    public Object execute() throws Exception {
        for (String container : this.containers) {
            this.getDockerService().rm(container, this.removeVolumes, this.force, this.url);
        }
        return null;
    }
}

