/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import org.apache.karaf.docker.Container;
import org.apache.karaf.docker.Port;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="docker", name="ps", description="List containers")
@Service
public class PsCommand
extends DockerCommandSupport {
    @Option(name="-a", aliases={"--all", "--showAll"}, description="Display all containers or only running ones", required=false, multiValued=false)
    boolean showAll;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Id");
        table.column("Names");
        table.column("Command");
        table.column("Created");
        table.column("Image");
        table.column("Image ID");
        table.column("Status");
        table.column("State");
        table.column("Ports");
        table.column("Size");
        table.column("Size Root");
        for (Container container : this.getDockerService().ps(this.showAll, this.url)) {
            StringBuffer portBuffer = new StringBuffer();
            for (Port port : container.getPorts()) {
                portBuffer.append(port.getType()).append(":").append(port.getPrivatePort()).append(":").append(port.getPublicPort()).append(" ");
            }
            table.addRow().addContent(new Object[]{container.getId(), container.getNames(), container.getCommand(), container.getCreated(), container.getImage(), container.getImageId(), container.getStatus(), container.getState(), portBuffer.toString(), container.getSizeRw(), container.getSizeRootFs()});
        }
        table.print(System.out);
        return null;
    }
}

