/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.List;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ContainersNameCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="kill", description="Kill one or more running containers")
@Service
public class KillCommand
extends DockerCommandSupport {
    @Argument(index=0, name="container", description="Name or ID of the containers to kill", required=true, multiValued=true)
    @Completion(value=ContainersNameCompleter.class)
    List<String> containers;
    @Option(name="--signal", description="The signal to send to the processes", required=false, multiValued=false)
    String signal = "SIGKILL";

    public Object execute() throws Exception {
        for (String container : this.containers) {
            this.getDockerService().kill(container, this.signal, this.url);
        }
        return null;
    }
}

