/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.docker.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.docker.ContainerConfig;
import org.apache.karaf.docker.HostConfig;
import org.apache.karaf.docker.HostPortBinding;
import org.apache.karaf.docker.command.DockerCommandSupport;
import org.apache.karaf.docker.command.completers.ImagesRepoTagsCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="docker", name="create", description="Create a new container")
@Service
public class CreateCommand
extends DockerCommandSupport {
    @Argument(index=0, name="name", description="The container of the Docker container", required=true, multiValued=false)
    String name;
    @Option(name="--hostname", description="Hostname of the Docker container", required=false, multiValued=false)
    String hostname = "docker";
    @Option(name="--user", description="User of the Docker container", required=false, multiValued=false)
    String user = "";
    @Option(name="--tty", description="Enable TTY for the Docker container", required=false, multiValued=false)
    boolean tty = true;
    @Option(name="--attachStdout", description="Attach stdout for the Docker container", required=false, multiValued=false)
    boolean attachStdout = true;
    @Option(name="--attachStderr", description="Attach stderr for the Docker container", required=false, multiValued=false)
    boolean attachStderr = true;
    @Option(name="--attachStdin", description="Attach stdin for the Docker container", required=false, multiValued=false)
    boolean attachStdin = true;
    @Option(name="--image", description="Image to use for the Docker container", required=false, multiValued=false)
    @Completion(value=ImagesRepoTagsCompleter.class)
    String image = "karaf:4.2.0";
    @Option(name="--cmd", description="Command to execute when starting the Docker container", required=false, multiValued=false)
    String cmd = "/bin/karaf";
    @Option(name="--workingDir", description="Working directory of the Docker container", required=false, multiValued=false)
    String workingDir = "";
    @Option(name="--openStdin", description="Enable and open stdin for the Docker container", required=false, multiValued=false)
    boolean openStdin = true;
    @Option(name="--stdinOnce", description="Enable single use of std in the Docker container", required=false, multiValued=false)
    boolean stdinOnce = true;
    @Option(name="--exposedPort", description="Port to expose from the Docker container", required=false, multiValued=false)
    String exposedPort = "8101/tcp";
    @Option(name="--hostPrivileged", description="Set host config privileges for the Docker container", required=false, multiValued=false)
    boolean hostPrivileged = false;
    @Option(name="--hostPublishAllPorts", description="Expose all ports for the Docker container", required=false, multiValued=false)
    boolean hostPublishAllPorts = false;
    @Option(name="--hostNetworkMode", description="Define the network mode for the Docker container", required=false, multiValued=false)
    String hostNetworkMode = "bridge";
    @Option(name="--hostPortBinding", description="Define the port binding for the Docker container", required=false, multiValued=false)
    String hostPortBinding = "8101";

    public Object execute() throws Exception {
        ContainerConfig containerConfig = new ContainerConfig();
        containerConfig.setTty(this.tty);
        containerConfig.setAttachStdin(this.attachStdin);
        containerConfig.setAttachStderr(this.attachStderr);
        containerConfig.setAttachStdout(this.attachStdout);
        containerConfig.setImage(this.image);
        containerConfig.setHostname(this.hostname);
        containerConfig.setUser(this.user);
        containerConfig.setCmd(new String[]{this.cmd});
        containerConfig.setWorkingDir(this.workingDir);
        containerConfig.setOpenStdin(this.openStdin);
        containerConfig.setStdinOnce(this.stdinOnce);
        HashMap<String, Map<String, String>> exposedPorts = new HashMap<String, Map<String, String>>();
        exposedPorts.put(this.exposedPort, new HashMap());
        containerConfig.setExposedPorts(exposedPorts);
        HostConfig hostConfig = new HostConfig();
        hostConfig.setPrivileged(this.hostPrivileged);
        hostConfig.setPublishAllPorts(this.hostPublishAllPorts);
        hostConfig.setNetworkMode(this.hostNetworkMode);
        hostConfig.setLxcConf(new String[0]);
        HashMap portBindings = new HashMap();
        ArrayList<HostPortBinding> hostPortBindings = new ArrayList<HostPortBinding>();
        HostPortBinding portBinding = new HostPortBinding();
        portBinding.setHostIp("");
        portBinding.setHostPort(this.hostPortBinding);
        hostPortBindings.add(portBinding);
        portBindings.put(this.exposedPort, hostPortBindings);
        this.getDockerService().create(this.name, this.url, containerConfig);
        return null;
    }
}

