/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.aries.subsystem.ContentHandler;
import org.apache.aries.subsystem.core.content.ConfigAdminContentHandler;
import org.apache.aries.subsystem.core.internal.ApplicationServiceModeller;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleEventHook;
import org.apache.aries.subsystem.core.internal.LockingStrategy;
import org.apache.aries.subsystem.core.internal.ServiceModeller;
import org.apache.aries.subsystem.core.internal.StopAction;
import org.apache.aries.subsystem.core.internal.SubsystemResolverHookFactory;
import org.apache.aries.subsystem.core.internal.SubsystemServiceRegistrar;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.apache.aries.subsystem.core.internal.SystemRepository;
import org.apache.aries.subsystem.core.internal.SystemRepositoryManager;
import org.apache.aries.subsystem.core.internal.WovenClassListener;
import org.apache.aries.util.filesystem.IDirectoryFinder;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.service.coordinator.Coordinator;
import org.osgi.service.resolver.Resolver;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
ServiceTrackerCustomizer<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    public static final String MODELLED_RESOURCE_MANAGER = "org.apache.aries.application.modelling.ModelledResourceManager";
    private static final String LOCK_TIMEOUT = "org.apache.aries.subsystem.lock.timeout";
    public static final String LOG_ENTRY = "Method entry: {}, args {}";
    public static final String LOG_EXIT = "Method exit: {}, returning {}";
    private static volatile Activator instance;
    private volatile BundleContext bundleContext;
    private volatile LockingStrategy lockingStrategy;
    private volatile ConfigAdminContentHandler configAdminHandler;
    private volatile Coordinator coordinator;
    private volatile Object modelledResourceManager;
    private volatile RegionDigraph regionDigraph;
    private volatile SubsystemServiceRegistrar registrar;
    private volatile Resolver resolver;
    private volatile ServiceModeller serviceModeller;
    private volatile Subsystems subsystems;
    private volatile SystemRepositoryManager systemRepositoryManager;
    private BundleEventHook bundleEventHook;
    private ServiceTracker<?, ?> serviceTracker;
    private final Collection<IDirectoryFinder> finders = Collections.synchronizedSet(new HashSet());
    private final Collection<ServiceRegistration<?>> registrations = new HashSet();

    public static Activator getInstance() {
        Activator result = instance;
        if (result == null) {
            throw new IllegalStateException("The activator has not been initialized or has been shutdown");
        }
        return result;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public LockingStrategy getLockingStrategy() {
        return this.lockingStrategy;
    }

    public Coordinator getCoordinator() {
        return this.coordinator;
    }

    public ServiceModeller getServiceModeller() {
        return this.serviceModeller;
    }

    public RegionDigraph getRegionDigraph() {
        return this.regionDigraph;
    }

    public Collection<IDirectoryFinder> getIDirectoryFinders() {
        return Collections.unmodifiableCollection(this.finders);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public Subsystems getSubsystems() {
        return this.subsystems;
    }

    public SubsystemServiceRegistrar getSubsystemServiceRegistrar() {
        logger.debug(LOG_ENTRY, (Object)"getSubsystemServiceRegistrar");
        SubsystemServiceRegistrar result = this.registrar;
        logger.debug(LOG_EXIT, (Object)"getSubsystemServiceRegistrar", (Object)result);
        return result;
    }

    public SystemRepository getSystemRepository() {
        return this.systemRepositoryManager.getSystemRepository();
    }

    public synchronized void start(BundleContext context) throws Exception {
        logger.debug(LOG_ENTRY, (Object)"start", (Object)context);
        this.bundleContext = context;
        this.lockingStrategy = new LockingStrategy(this.bundleContext.getProperty(LOCK_TIMEOUT));
        this.serviceTracker = new ServiceTracker(this.bundleContext, this.generateServiceFilter(), (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
        logger.debug(LOG_EXIT, (Object)"start");
    }

    public synchronized void stop(BundleContext context) {
        logger.debug(LOG_ENTRY, (Object)"stop", (Object)context);
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.bundleContext = null;
        logger.debug(LOG_EXIT, (Object)"stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activate() {
        if (this.isActive() || !this.hasRequiredServices()) {
            return;
        }
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.subsystems = new Subsystems();
            this.registerBundleEventHook();
            this.registrations.add(this.bundleContext.registerService(ResolverHookFactory.class, (Object)new SubsystemResolverHookFactory(this.subsystems), null));
            Hashtable<String, String[]> handlerProps = new Hashtable<String, String[]>();
            ((Dictionary)handlerProps).put("org.aries.subsystem.contenthandler.type", ConfigAdminContentHandler.CONTENT_TYPES);
            this.configAdminHandler = new ConfigAdminContentHandler(this.bundleContext);
            this.registrations.add(this.bundleContext.registerService(ContentHandler.class, (Object)this.configAdminHandler, handlerProps));
            this.registrar = new SubsystemServiceRegistrar(this.bundleContext);
            this.systemRepositoryManager = new SystemRepositoryManager(this.bundleContext.getBundle(0L).getBundleContext());
            this.systemRepositoryManager.open();
            BasicSubsystem root = this.subsystems.getRootSubsystem();
            this.bundleEventHook.activate();
            root.start();
            this.registerWovenClassListener();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.bundleEventHook.deactivate();
        this.systemRepositoryManager.close();
        new StopAction(this.subsystems.getRootSubsystem(), this.subsystems.getRootSubsystem(), true).run();
        for (ServiceRegistration<?> registration : this.registrations) {
            try {
                registration.unregister();
            }
            catch (IllegalStateException e) {
                logger.debug("Service had already been unregistered", (Throwable)e);
            }
        }
        this.configAdminHandler.shutDown();
        this.bundleEventHook.processPendingEvents();
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private <T> T findAlternateServiceFor(Class<T> service) {
        Object[] services = this.serviceTracker.getServices();
        if (services == null) {
            return null;
        }
        for (Object alternate : services) {
            if (!service.isInstance(alternate)) continue;
            return service.cast(alternate);
        }
        return null;
    }

    private Filter generateServiceFilter() throws InvalidSyntaxException {
        return FrameworkUtil.createFilter((String)this.generateServiceFilterString());
    }

    private String generateServiceFilterString() {
        return "(|(" + "objectClass" + '=' + Coordinator.class.getName() + ")(" + "objectClass" + '=' + RegionDigraph.class.getName() + ")(" + "objectClass" + '=' + Resolver.class.getName() + ")(" + "objectClass" + '=' + "org.osgi.service.repository.Repository" + ")(" + "objectClass" + '=' + MODELLED_RESOURCE_MANAGER + ")(" + "objectClass" + '=' + IDirectoryFinder.class.getName() + "))";
    }

    private boolean hasRequiredServices() {
        return this.coordinator != null && this.regionDigraph != null && this.resolver != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isActive() {
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance != null && this.getSubsystems() != null;
        }
    }

    private void registerBundleEventHook() {
        Hashtable<String, Integer> properties = new Hashtable<String, Integer>(1);
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        this.bundleEventHook = new BundleEventHook();
        this.registrations.add(this.bundleContext.registerService(EventHook.class, (Object)this.bundleEventHook, properties));
    }

    private void registerWovenClassListener() {
        this.registrations.add(this.bundleContext.registerService(org.osgi.framework.hooks.weaving.WovenClassListener.class, (Object)new WovenClassListener(this.bundleContext, this.subsystems), null));
    }

    public synchronized Object addingService(ServiceReference<Object> reference) {
        Object service = this.bundleContext.getService(reference);
        if (service instanceof IDirectoryFinder) {
            this.finders.add((IDirectoryFinder)service);
        } else if (service instanceof Coordinator && this.coordinator == null) {
            this.coordinator = (Coordinator)service;
        } else if (service instanceof RegionDigraph && this.regionDigraph == null) {
            this.regionDigraph = (RegionDigraph)service;
        } else if (service instanceof Resolver && this.resolver == null) {
            this.resolver = (Resolver)service;
        } else {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(MODELLED_RESOURCE_MANAGER);
                if (clazz.isInstance(service) && this.serviceModeller == null) {
                    this.modelledResourceManager = service;
                    this.serviceModeller = new ApplicationServiceModeller(service);
                } else {
                    service = null;
                }
            }
            catch (ClassNotFoundException e) {
                service = null;
            }
            catch (NoClassDefFoundError e) {
                service = null;
            }
        }
        this.activate();
        return service;
    }

    public void modifiedService(ServiceReference<Object> reference, Object service) {
    }

    public synchronized void removedService(ServiceReference<Object> reference, Object service) {
        if (service instanceof Coordinator) {
            if (service.equals(this.coordinator)) {
                Coordinator coordinator = this.findAlternateServiceFor(Coordinator.class);
                if (coordinator == null) {
                    this.deactivate();
                }
                this.coordinator = coordinator;
            }
        } else if (service instanceof RegionDigraph) {
            if (service.equals(this.regionDigraph)) {
                RegionDigraph regionDigraph = this.findAlternateServiceFor(RegionDigraph.class);
                if (regionDigraph == null) {
                    this.deactivate();
                }
                this.regionDigraph = regionDigraph;
            }
        } else if (service instanceof Resolver) {
            if (service.equals(this.resolver)) {
                Resolver resolver = this.findAlternateServiceFor(Resolver.class);
                if (resolver == null) {
                    this.deactivate();
                }
                this.resolver = resolver;
            }
        } else if (service instanceof IDirectoryFinder) {
            this.finders.remove(service);
        } else if (service.equals(this.modelledResourceManager)) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(MODELLED_RESOURCE_MANAGER);
                Object manager = this.findAlternateServiceFor(clazz);
                if (manager == null) {
                    this.modelledResourceManager = null;
                    this.serviceModeller = null;
                } else {
                    this.modelledResourceManager = service;
                    this.serviceModeller = new ApplicationServiceModeller(service);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }
}

