/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import org.apache.aries.subsystem.core.archive.AbstractDirective;

public class VisibilityDirective
extends AbstractDirective {
    public static final String NAME = "visibility";
    public static final String VALUE_PRIVATE = "private";
    public static final String VALUE_REEXPORT = "reexport";
    public static final VisibilityDirective PRIVATE = new VisibilityDirective("private");
    public static final VisibilityDirective REEXPORT = new VisibilityDirective("reexport");

    public static VisibilityDirective getInstance(String value) {
        if (VALUE_PRIVATE.equals(value)) {
            return PRIVATE;
        }
        if (VALUE_REEXPORT.equals(value)) {
            return REEXPORT;
        }
        return new VisibilityDirective(value);
    }

    public VisibilityDirective() {
        this(VALUE_PRIVATE);
    }

    public VisibilityDirective(String value) {
        super(NAME, value);
    }

    public boolean isPrivate() {
        return PRIVATE == this || VALUE_PRIVATE.equals(this.getValue());
    }

    public boolean isReexport() {
        return REEXPORT == this || VALUE_REEXPORT.equals(this.getValue());
    }
}

