/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.ImportPackageHeader;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.resource.Resource;

public class ImportPackageRequirement
extends AbstractRequirement {
    public static final String DIRECTIVE_FILTER = "filter";
    public static final String NAMESPACE = "osgi.wiring.package";
    private final Map<String, String> directives;
    private final Resource resource;

    public ImportPackageRequirement(ImportPackageHeader.Clause clause, Resource resource) {
        Collection<Directive> clauseDirectives = clause.getDirectives();
        this.directives = new HashMap<String, String>(clauseDirectives.size() + 1);
        for (Directive directive : clauseDirectives) {
            this.directives.put(directive.getName(), directive.getValue());
        }
        Collection<String> packageNames = clause.getPackageNames();
        if (packageNames.isEmpty() || packageNames.size() > 1) {
            throw new IllegalArgumentException("Only one package name per requirement allowed");
        }
        StringBuilder filter = new StringBuilder("(&(").append(NAMESPACE).append('=').append(packageNames.iterator().next()).append(')');
        VersionRangeAttribute versionRange = clause.getVersionRangeAttribute();
        if (versionRange != null) {
            versionRange.appendToFilter(filter);
        }
        for (Attribute packageAttribute : clause.getAttributes()) {
            if (packageAttribute instanceof VersionRangeAttribute) continue;
            packageAttribute.appendToFilter(filter);
        }
        this.directives.put(DIRECTIVE_FILTER, filter.append(')').toString());
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return Collections.emptyMap();
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public Resource getResource() {
        return this.resource;
    }
}

