/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfaceType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.InterfacesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state.InterfaceKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.interfaces.rev140508.interfaces.state._interface.Statistics;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.DateAndTime;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.Gauge64;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.PhysAddress;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

public interface Interface
extends ChildOf<InterfacesState>,
Augmentable<Interface>,
Identifiable<InterfaceKey> {
    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("interface");

    public @Nullable String getName();

    public @Nullable Class<? extends InterfaceType> getType();

    public @Nullable AdminStatus getAdminStatus();

    public @Nullable OperStatus getOperStatus();

    public @Nullable DateAndTime getLastChange();

    public @Nullable Integer getIfIndex();

    public @Nullable PhysAddress getPhysAddress();

    public @Nullable List<String> getHigherLayerIf();

    public @Nullable List<String> getLowerLayerIf();

    public @Nullable Gauge64 getSpeed();

    public @Nullable Statistics getStatistics();

    public InterfaceKey key();

    public static enum OperStatus implements Enumeration
    {
        Up(1, "up"),
        Down(2, "down"),
        Testing(3, "testing"),
        Unknown(4, "unknown"),
        Dormant(5, "dormant"),
        NotPresent(6, "not-present"),
        LowerLayerDown(7, "lower-layer-down");

        private static final Map<String, OperStatus> NAME_MAP;
        private static final Map<Integer, OperStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private OperStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<OperStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static OperStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (OperStatus enumItem : OperStatus.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }

    public static enum AdminStatus implements Enumeration
    {
        Up(1, "up"),
        Down(2, "down"),
        Testing(3, "testing");

        private static final Map<String, AdminStatus> NAME_MAP;
        private static final Map<Integer, AdminStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private AdminStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<AdminStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static AdminStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (AdminStatus enumItem : AdminStatus.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

