/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class Dscp
implements TypeObject,
Serializable {
    private static final long serialVersionUID = -6062481917342980428L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= 0 && value <= 63) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..63]]", (int)value);
    }

    @ConstructorProperties(value={"value"})
    public Dscp(Short _value) {
        if (_value != null) {
            Dscp.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public Dscp(Dscp source) {
        this._value = source._value;
    }

    public static Dscp getDefaultInstance(String defaultValue) {
        return new Dscp(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dscp other = (Dscp)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Dscp.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
        return helper.toString();
    }
}

