/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.CredentialExtractor;
import org.ops4j.pax.transx.jdbc.impl.ConnectionHandle;
import org.ops4j.pax.transx.jdbc.impl.LocalDataSourceMCF;

public class ManagedJDBCConnection
extends AbstractManagedConnection<LocalDataSourceMCF, ManagedJDBCConnection, Connection, ConnectionHandle<LocalDataSourceMCF, ManagedJDBCConnection>> {
    private final Connection physicalConnection;
    private final AbstractManagedConnection.LocalTransactionImpl localTx;
    private final AbstractManagedConnection.LocalTransactionImpl localClientTx;

    public ManagedJDBCConnection(LocalDataSourceMCF mcf, Connection physicalConnection, CredentialExtractor credentialExtractor, ExceptionSorter exceptionSorter) {
        super(mcf, credentialExtractor, exceptionSorter);
        this.physicalConnection = physicalConnection;
        this.localTx = new AbstractManagedConnection.LocalTransactionImpl(true);
        this.localClientTx = new AbstractManagedConnection.LocalTransactionImpl(false);
    }

    @Override
    public Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    @Override
    public LocalTransaction getClientLocalTransaction() {
        return this.localClientTx;
    }

    @Override
    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTx;
    }

    @Override
    protected boolean isValid() {
        try {
            if (this.getPhysicalConnection().isValid(0)) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected void localTransactionStart(boolean isSPI) throws ResourceException {
        try {
            this.getPhysicalConnection().setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to disable autoCommit", (Throwable)e);
        }
        super.localTransactionStart(isSPI);
    }

    @Override
    protected void localTransactionCommit(boolean isSPI) throws ResourceException {
        try {
            if (((LocalDataSourceMCF)this.mcf).isCommitBeforeAutocommit()) {
                this.getPhysicalConnection().commit();
            }
            this.getPhysicalConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            block5: {
                try {
                    this.getPhysicalConnection().rollback();
                }
                catch (SQLException e1) {
                    if (this.log == null) break block5;
                    e.printStackTrace(this.log);
                }
            }
            throw new LocalTransactionException("Unable to commit", (Throwable)e);
        }
        super.localTransactionCommit(isSPI);
    }

    @Override
    protected void localTransactionRollback(boolean isSPI) throws ResourceException {
        try {
            this.getPhysicalConnection().rollback();
        }
        catch (SQLException e) {
            throw new LocalTransactionException("Unable to rollback", (Throwable)e);
        }
        super.localTransactionRollback(isSPI);
        try {
            this.getPhysicalConnection().setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Unable to enable autoCommit after rollback", (Throwable)e);
        }
    }

    @Override
    public void cleanup() throws ResourceException {
        super.cleanup();
        try {
            if (!this.getPhysicalConnection().getAutoCommit()) {
                this.getPhysicalConnection().setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ResourceException("Could not reset autocommit when returning to pool", (Throwable)e);
        }
    }

    @Override
    protected void closePhysicalConnection() throws ResourceException {
        try {
            this.getPhysicalConnection().close();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException("Error attempting to destroy managed connection", (Throwable)e);
        }
    }

    @Override
    protected void attemptRollback() {
        try {
            this.getPhysicalConnection().rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

