/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jdbc.impl;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.sql.CommonDataSource;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnection;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnectionFactory;
import org.ops4j.pax.transx.jdbc.impl.AutocommitSpecCompliant;
import org.ops4j.pax.transx.jdbc.impl.ConnectionHandle;
import org.ops4j.pax.transx.jdbc.impl.ConnectionWrapper;
import org.ops4j.pax.transx.jdbc.impl.TransxDataSource;

public abstract class AbstractJdbcManagedConnectionFactory<MCF extends AbstractManagedConnectionFactory<MCF, MC, Connection, ConnectionHandle<MCF, MC>>, MC extends AbstractManagedConnection<MCF, MC, Connection, ConnectionHandle<MCF, MC>>, T extends CommonDataSource>
extends AbstractManagedConnectionFactory<MCF, MC, Connection, ConnectionHandle<MCF, MC>>
implements AutocommitSpecCompliant {
    protected final T dataSource;
    protected boolean commitBeforeAutocommit = false;
    protected int preparedStatementCacheSize = 0;
    protected int transactionIsolationLevel = -1;

    protected AbstractJdbcManagedConnectionFactory(T dataSource, ExceptionSorter exceptionSorter) {
        this.dataSource = dataSource;
        this.exceptionSorter = exceptionSorter;
    }

    @Override
    public ConnectionHandle<MCF, MC> createConnectionHandle(ConnectionRequestInfo cri, MC mc) {
        return new ConnectionHandle<AbstractJdbcManagedConnectionFactory, MC>(this, cri, mc);
    }

    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new TransxDataSource(this, connectionManager);
    }

    @Override
    public boolean isCommitBeforeAutocommit() {
        return this.commitBeforeAutocommit;
    }

    public void setCommitBeforeAutocommit(boolean commitBeforeAutocommit) {
        this.commitBeforeAutocommit = commitBeforeAutocommit;
    }

    public int getPreparedStatementCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public void setPreparedStatementCacheSize(int preparedStatementCacheSize) {
        this.preparedStatementCacheSize = preparedStatementCacheSize;
    }

    protected Connection wrap(Connection connection) {
        if (this.preparedStatementCacheSize > 0) {
            return new ConnectionWrapper(connection, this.preparedStatementCacheSize);
        }
        return connection;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.dataSource.getLogWriter();
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void setLogWriter(PrintWriter log) throws ResourceException {
        try {
            this.dataSource.setLogWriter(log);
        }
        catch (SQLException e) {
            throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
        }
    }

    public int getLoginTimeout() {
        int timeout;
        try {
            timeout = this.dataSource.getLoginTimeout();
        }
        catch (SQLException e) {
            timeout = 0;
        }
        return timeout;
    }

    public void setLoginTimeout(int timeout) throws ResourceException {
        try {
            this.dataSource.setLoginTimeout(timeout);
        }
        catch (SQLException e) {
            throw new InvalidPropertyException(e.getMessage());
        }
    }

    public int getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass()) {
            AbstractJdbcManagedConnectionFactory other = (AbstractJdbcManagedConnectionFactory)obj;
            return this.dataSource.equals(other.dataSource);
        }
        return false;
    }

    public int hashCode() {
        return this.dataSource.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.dataSource + "]";
    }
}

