/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extender.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.ops4j.pax.cdi.extender.impl.BundleCdi;
import org.ops4j.pax.cdi.extender.impl.BundleCdiProvider;
import org.ops4j.pax.cdi.extender.impl.DelegatingCdiContainer;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.ops4j.pax.cdi.spi.CdiWebAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiExtender
implements BundleTrackerCustomizer<CdiContainer>,
ServiceTrackerCustomizer<CdiWebAdapter, CdiWebAdapter> {
    private static Logger log = LoggerFactory.getLogger(CdiExtender.class);
    private final BundleContext context;
    private final CdiContainerFactory factory;
    private final CDIProvider cdiProvider;
    private BundleTracker<CdiContainer> bundleWatcher;
    private ServiceTracker<CdiWebAdapter, CdiWebAdapter> listenerTracker;
    private CdiWebAdapter webAdapter;
    private Map<Long, Bundle> webBundles = new HashMap<Long, Bundle>();

    CdiExtender(BundleContext context, CdiContainerFactory factory) {
        this.context = context;
        this.factory = factory;
        this.cdiProvider = new BundleCdiProvider(factory);
    }

    synchronized void start() {
        CDI.setCDIProvider((CDIProvider)this.cdiProvider);
        log.info("starting CDI extender {}", (Object)this.context.getBundle().getSymbolicName());
        this.listenerTracker = new ServiceTracker(this.context, CdiWebAdapter.class, (ServiceTrackerCustomizer)this);
        this.listenerTracker.open();
        this.bundleWatcher = new BundleTracker(this.context, 32, (BundleTrackerCustomizer)this);
        this.bundleWatcher.open();
    }

    synchronized void stop() {
        BundleCdi.dispose();
        log.info("stopping CDI extender {}", (Object)this.context.getBundle().getSymbolicName());
        this.bundleWatcher.close();
        this.listenerTracker.close();
    }

    public synchronized CdiContainer addingBundle(Bundle bundle, BundleEvent event) {
        boolean wired = false;
        List wires = ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires("osgi.extender");
        if (wires != null) {
            for (BundleWire wire : wires) {
                if (!wire.getProviderWiring().getBundle().equals(this.context.getBundle())) continue;
                wired = true;
                break;
            }
        }
        if (wired) {
            log.debug("found bean bundle: {}", (Object)bundle.getSymbolicName());
            return this.createContainer(bundle);
        }
        log.trace("not a bean bundle: {}", (Object)bundle.getSymbolicName());
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, CdiContainer object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removedBundle(Bundle bundle, BundleEvent event, CdiContainer container) {
        if (container != null) {
            CdiContainer cdiContainer = container;
            synchronized (cdiContainer) {
                container.stop();
            }
        }
        this.factory.removeContainer(bundle);
        if (this.webAdapter != null) {
            this.webAdapter.preDestroy(container);
        }
    }

    private CdiContainer createContainer(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String contextPath = (String)headers.get("Web-ContextPath");
        boolean isWebBundle = contextPath != null;
        CdiContainer container = null;
        if (isWebBundle) {
            if (this.webAdapter == null) {
                log.debug("waiting for web adapter for {}", (Object)bundle);
                this.webBundles.put(bundle.getBundleId(), bundle);
            } else {
                container = this.doCreateLazyContainer(bundle);
            }
        } else {
            container = this.doCreateContainer(bundle);
            container.start(new Object());
        }
        return container;
    }

    private CdiContainer doCreateContainer(Bundle bundle) {
        HashSet extensions = new HashSet();
        BeanBundles.findExtensions((Bundle)bundle, extensions);
        log.info("creating CDI container for bean bundle {} with extension bundles {}", (Object)bundle, extensions);
        return this.factory.createContainer(bundle, extensions);
    }

    private CdiContainer doCreateLazyContainer(Bundle bundle) {
        DelegatingCdiContainer container = new DelegatingCdiContainer(this.factory, bundle);
        if (this.webAdapter != null) {
            this.webAdapter.postCreate((CdiContainer)container);
        }
        return container;
    }

    public synchronized CdiWebAdapter addingService(ServiceReference<CdiWebAdapter> reference) {
        CdiWebAdapter service = (CdiWebAdapter)this.context.getService(reference);
        if (this.webAdapter == null) {
            this.setWebAdapter(service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<CdiWebAdapter> reference, CdiWebAdapter service) {
    }

    public synchronized void removedService(ServiceReference<CdiWebAdapter> reference, CdiWebAdapter service) {
        if (this.webAdapter == service) {
            this.setWebAdapter((CdiWebAdapter)this.listenerTracker.getService());
        }
        this.context.ungetService(reference);
    }

    private void setWebAdapter(CdiWebAdapter listener) {
        log.debug("adding web adapter");
        this.webAdapter = listener;
        for (Bundle bundle : this.webBundles.values()) {
            this.doCreateLazyContainer(bundle);
        }
        this.webBundles.clear();
    }
}

