/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spec.naming;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;

@Beta
public final class BindingMapping {
    public static final String VERSION = "0.6";
    public static final Set<String> JAVA_RESERVED_WORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object)"case", (Object[])new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "_", "false", "true", "null"});
    public static final String DATA_ROOT_SUFFIX = "Data";
    public static final String RPC_SERVICE_SUFFIX = "Service";
    public static final String NOTIFICATION_LISTENER_SUFFIX = "Listener";
    public static final String QNAME_STATIC_FIELD_NAME = "QNAME";
    public static final String PACKAGE_PREFIX = "org.opendaylight.yang.gen.v1";
    public static final String AUGMENTATION_FIELD = "augmentation";
    private static final Splitter CAMEL_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" _.-/").precomputed()).omitEmptyStrings().trimResults();
    private static final Pattern COLON_SLASH_SLASH = Pattern.compile("://", 16);
    private static final String QUOTED_DOT = Matcher.quoteReplacement(".");
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    public static final String MODULE_INFO_CLASS_NAME = "$YangModuleInfoImpl";
    public static final String MODULE_INFO_QNAMEOF_METHOD_NAME = "qnameOf";
    public static final String MODEL_BINDING_PROVIDER_CLASS_NAME = "$YangModelBindingProvider";
    public static final String AUGMENTABLE_AUGMENTATION_NAME = "augmentation";
    public static final String IDENTIFIABLE_KEY_NAME = "key";
    public static final String DATA_CONTAINER_GET_IMPLEMENTED_INTERFACE_NAME = "getImplementedInterface";
    public static final String BOOLEAN_GETTER_PREFIX = "is";
    public static final String GETTER_PREFIX = "get";
    public static final String NONNULL_PREFIX = "nonnull";
    public static final String RPC_INPUT_SUFFIX = "Input";
    public static final String RPC_OUTPUT_SUFFIX = "Output";
    private static final Interner<String> PACKAGE_INTERNER = Interners.newWeakInterner();

    private BindingMapping() {
        throw new UnsupportedOperationException("Utility class should not be instantiated");
    }

    public static String getRootPackageName(QName module) {
        return BindingMapping.getRootPackageName(module.getModule());
    }

    public static String getRootPackageName(QNameModule module) {
        Optional optRev;
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module must not be null");
        Preconditions.checkArgument((module.getRevision() != null ? 1 : 0) != 0, (Object)"Revision must not be null");
        Preconditions.checkArgument((module.getNamespace() != null ? 1 : 0) != 0, (Object)"Namespace must not be null");
        StringBuilder packageNameBuilder = new StringBuilder();
        packageNameBuilder.append(PACKAGE_PREFIX);
        packageNameBuilder.append('.');
        String namespace = module.getNamespace().toString();
        namespace = COLON_SLASH_SLASH.matcher(namespace).replaceAll(QUOTED_DOT);
        char[] chars = namespace.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': 
                case '$': 
                case '\'': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': {
                    chars[i] = 46;
                    continue block3;
                }
            }
        }
        packageNameBuilder.append(chars);
        if (chars[chars.length - 1] != '.') {
            packageNameBuilder.append('.');
        }
        if ((optRev = module.getRevision()).isPresent()) {
            String rev = ((Revision)optRev.get()).toString();
            Preconditions.checkArgument((rev.length() == 10 ? 1 : 0) != 0, (String)"Unsupported revision %s", (Object)rev);
            packageNameBuilder.append("rev").append(rev, 2, 4).append(rev, 5, 7).append(rev.substring(8));
        } else {
            packageNameBuilder.append("norev");
        }
        return BindingMapping.normalizePackageName(packageNameBuilder.toString());
    }

    public static String normalizePackageName(String packageName) {
        if (packageName == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String p : DOT_SPLITTER.split((CharSequence)packageName.toLowerCase(Locale.ENGLISH))) {
            if (first) {
                first = false;
            } else {
                builder.append('.');
            }
            if (Character.isDigit(p.charAt(0)) || JAVA_RESERVED_WORDS.contains(p)) {
                builder.append('_');
            }
            builder.append(p);
        }
        return (String)PACKAGE_INTERNER.intern((Object)builder.toString());
    }

    public static String getClassName(String localName) {
        Preconditions.checkArgument((localName != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(localName));
    }

    public static String getClassName(QName name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
    }

    public static String getMethodName(String yangIdentifier) {
        Preconditions.checkArgument((yangIdentifier != null ? 1 : 0) != 0, (Object)"Identifier should not be null");
        return BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
    }

    public static String getMethodName(QName name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        return BindingMapping.getMethodName(name.getLocalName());
    }

    public static String getGetterPrefix(boolean isBoolean) {
        return isBoolean ? BOOLEAN_GETTER_PREFIX : GETTER_PREFIX;
    }

    public static String getGetterMethodName(String localName, boolean isBoolean) {
        return BindingMapping.getGetterPrefix(isBoolean) + BindingMapping.toFirstUpper(BindingMapping.getPropertyName(localName));
    }

    public static String getGetterMethodName(QName name, boolean isBoolean) {
        return BindingMapping.getGetterPrefix(isBoolean) + BindingMapping.getGetterSuffix(name);
    }

    public static boolean isGetterMethodName(String methodName) {
        return methodName.startsWith(GETTER_PREFIX) || methodName.startsWith(BOOLEAN_GETTER_PREFIX);
    }

    public static String getGetterMethodForNonnull(String methodName) {
        Preconditions.checkArgument((boolean)BindingMapping.isNonnullMethodName(methodName));
        return GETTER_PREFIX + methodName.substring(NONNULL_PREFIX.length());
    }

    public static String getNonnullMethodName(String localName) {
        return NONNULL_PREFIX + BindingMapping.toFirstUpper(BindingMapping.getPropertyName(localName));
    }

    public static boolean isNonnullMethodName(String methodName) {
        return methodName.startsWith(NONNULL_PREFIX);
    }

    public static String getGetterSuffix(QName name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name should not be null.");
        String candidate = BindingMapping.toFirstUpper(BindingMapping.toCamelCase(name.getLocalName()));
        return "Class".equals(candidate) ? "XmlClass" : candidate;
    }

    public static String getPropertyName(String yangIdentifier) {
        String potential = BindingMapping.toFirstLower(BindingMapping.toCamelCase(yangIdentifier));
        if ("class".equals(potential)) {
            return "xmlClass";
        }
        return potential;
    }

    private static String toCamelCase(String rawString) {
        Preconditions.checkArgument((rawString != null ? 1 : 0) != 0, (Object)"String should not be null");
        Iterable components = CAMEL_SPLITTER.split((CharSequence)rawString);
        StringBuilder builder = new StringBuilder();
        for (String comp : components) {
            builder.append(BindingMapping.toFirstUpper(comp));
        }
        return BindingMapping.checkNumericPrefix(builder.toString());
    }

    private static String checkNumericPrefix(String rawString) {
        if (rawString == null || rawString.isEmpty()) {
            return rawString;
        }
        char firstChar = rawString.charAt(0);
        return firstChar >= '0' && firstChar <= '9' ? "_" + rawString : rawString;
    }

    public static String toFirstUpper(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    private static String toFirstLower(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toLowerCase(Locale.ENGLISH) + str.substring(1);
    }

    public static BiMap<String, String> mapEnumAssignedNames(Collection<String> assignedNames) {
        HashBiMap javaToYang = HashBiMap.create((int)assignedNames.size());
        boolean valid = true;
        for (String name : assignedNames) {
            String mappedName;
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            if (javaToYang.containsValue((Object)name) || BindingMapping.isValidJavaIdentifier(mappedName = BindingMapping.getClassName(name)) && javaToYang.forcePut((Object)mappedName, (Object)name) == null) continue;
            valid = false;
            break;
        }
        if (!valid) {
            javaToYang.clear();
            for (String name : assignedNames) {
                javaToYang.put((Object)BindingMapping.mapEnumAssignedName(name), (Object)name);
            }
        }
        return javaToYang.inverse();
    }

    private static boolean isValidJavaIdentifier(String str) {
        return !str.isEmpty() && !JAVA_RESERVED_WORDS.contains(str) && Character.isJavaIdentifierStart(str.codePointAt(0)) && str.codePoints().skip(1L).allMatch(Character::isJavaIdentifierPart);
    }

    private static String mapEnumAssignedName(String assignedName) {
        Preconditions.checkArgument((!assignedName.isEmpty() ? 1 : 0) != 0);
        if (assignedName.indexOf(36) == -1 && BindingMapping.isValidJavaIdentifier(assignedName)) {
            return assignedName;
        }
        StringBuilder sb = new StringBuilder().append('$');
        assignedName.codePoints().forEachOrdered(codePoint -> {
            if (codePoint == 36 || !Character.isJavaIdentifierPart(codePoint)) {
                sb.append('$').append(Integer.toHexString(codePoint).toUpperCase(Locale.ROOT)).append('$');
            } else {
                sb.appendCodePoint(codePoint);
            }
        });
        return sb.toString();
    }
}

