/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.dom.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipChange;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.dom.impl.ClusterSingletonServiceGroup;
import org.opendaylight.yangtools.concepts.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PlaceholderGroup<P extends Path<P>, E extends GenericEntity<P>, C extends GenericEntityOwnershipChange<P, E>>
extends ClusterSingletonServiceGroup<P, E, C> {
    private static final Logger LOG = LoggerFactory.getLogger(PlaceholderGroup.class);
    private final List<ClusterSingletonServiceRegistration> services = new ArrayList<ClusterSingletonServiceRegistration>(0);
    private final ClusterSingletonServiceGroup<P, E, C> previous;
    private final ListenableFuture<?> closeFuture;
    private volatile ClusterSingletonServiceGroup<P, E, C> successor;

    PlaceholderGroup(ClusterSingletonServiceGroup<P, E, C> previous, ListenableFuture<?> closeFuture) {
        this.previous = Objects.requireNonNull(previous);
        this.closeFuture = Objects.requireNonNull(closeFuture);
    }

    public String getIdentifier() {
        return (String)this.previous.getIdentifier();
    }

    @Override
    void initialize() throws CandidateAlreadyRegisteredException {
        throw new UnsupportedOperationException("This should never be invoked");
    }

    @Override
    void registerService(ClusterSingletonServiceRegistration reg) {
        this.verifyNoSuccessor();
        this.services.add(reg);
        LOG.debug("{}: added service {}", (Object)this, reg.getInstance());
    }

    @Override
    ListenableFuture<?> unregisterService(ClusterSingletonServiceRegistration reg) {
        this.verifyNoSuccessor();
        this.services.remove(reg);
        LOG.debug("{}: removed service {}", (Object)this, reg.getInstance());
        return null;
    }

    @Override
    void ownershipChanged(C ownershipChange) {
        ClusterSingletonServiceGroup<P, E, C> local = this.successor;
        (local == null ? this.previous : local).ownershipChanged(ownershipChange);
    }

    @Override
    ListenableFuture<?> closeClusterSingletonGroup() {
        ClusterSingletonServiceGroup<P, E, C> local = this.successor;
        return local == null ? this.closeFuture : local.closeClusterSingletonGroup();
    }

    List<ClusterSingletonServiceRegistration> getServices() {
        this.verifyNoSuccessor();
        LOG.trace("{}: returning services {}", (Object)this, this.services);
        return this.services;
    }

    void setSuccessor(ClusterSingletonServiceGroup<P, E, C> successor) {
        this.verifyNoSuccessor();
        this.successor = (ClusterSingletonServiceGroup)Verify.verifyNotNull(successor);
        LOG.debug("{}: successor set to {}", (Object)this, successor);
    }

    private void verifyNoSuccessor() {
        Verify.verify((this.successor == null ? 1 : 0) != 0, (String)"Placeholder already superseded by %s", this.successor);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getIdentifier()).toString();
    }
}

