/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.singleton.dom.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.CandidateAlreadyRegisteredException;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipChange;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipListener;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipListenerRegistration;
import org.opendaylight.mdsal.eos.common.api.GenericEntityOwnershipService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.mdsal.singleton.dom.impl.AbstractClusterSingletonServiceRegistration;
import org.opendaylight.mdsal.singleton.dom.impl.ClusterSingletonServiceGroup;
import org.opendaylight.mdsal.singleton.dom.impl.ClusterSingletonServiceGroupImpl;
import org.opendaylight.mdsal.singleton.dom.impl.PlaceholderGroup;
import org.opendaylight.yangtools.concepts.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterSingletonServiceProviderImpl<P extends Path<P>, E extends GenericEntity<P>, C extends GenericEntityOwnershipChange<P, E>, G extends GenericEntityOwnershipListener<P, C>, S extends GenericEntityOwnershipService<P, E, G>, R extends GenericEntityOwnershipListenerRegistration<P, G>>
implements ClusterSingletonServiceProvider,
GenericEntityOwnershipListener<P, C> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClusterSingletonServiceProviderImpl.class);
    @VisibleForTesting
    static final String SERVICE_ENTITY_TYPE = "org.opendaylight.mdsal.ServiceEntityType";
    @VisibleForTesting
    static final String CLOSE_SERVICE_ENTITY_TYPE = "org.opendaylight.mdsal.AsyncServiceCloseEntityType";
    private final S entityOwnershipService;
    private final Map<String, ClusterSingletonServiceGroup<P, E, C>> serviceGroupMap = new ConcurrentHashMap<String, ClusterSingletonServiceGroup<P, E, C>>();
    private R serviceEntityListenerReg;
    private R asyncCloseEntityListenerReg;

    protected AbstractClusterSingletonServiceProviderImpl(@NonNull S entityOwnershipService) {
        this.entityOwnershipService = (GenericEntityOwnershipService)Objects.requireNonNull(entityOwnershipService);
    }

    public final void initializeProvider() {
        LOG.debug("Initialization method for ClusterSingletonService Provider {}", (Object)this);
        this.serviceEntityListenerReg = this.registerListener(SERVICE_ENTITY_TYPE, this.entityOwnershipService);
        this.asyncCloseEntityListenerReg = this.registerListener(CLOSE_SERVICE_ENTITY_TYPE, this.entityOwnershipService);
    }

    public final synchronized ClusterSingletonServiceRegistration registerClusterSingletonService(ClusterSingletonService service) {
        ClusterSingletonServiceGroup<P, E, C> serviceGroup;
        LOG.debug("Call registrationService {} method for ClusterSingletonService Provider {}", (Object)service, (Object)this);
        final String serviceIdentifier = (String)((ServiceGroupIdentifier)service.getIdentifier()).getValue();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceIdentifier) ? 1 : 0) != 0, (Object)"ClusterSingletonService identifier may not be null nor empty");
        ClusterSingletonServiceGroup<P, E, C> existing = this.serviceGroupMap.get(serviceIdentifier);
        if (existing == null) {
            serviceGroup = this.createGroup(serviceIdentifier, new ArrayList<ClusterSingletonServiceRegistration>(1));
            this.serviceGroupMap.put(serviceIdentifier, serviceGroup);
            try {
                this.initializeOrRemoveGroup(serviceGroup);
            }
            catch (CandidateAlreadyRegisteredException e) {
                throw new IllegalArgumentException("Service group already registered", e);
            }
        } else {
            serviceGroup = existing;
        }
        AbstractClusterSingletonServiceRegistration reg = new AbstractClusterSingletonServiceRegistration(service){

            protected void removeRegistration() {
                AbstractClusterSingletonServiceProviderImpl.this.removeRegistration(serviceIdentifier, this);
            }
        };
        serviceGroup.registerService(reg);
        return reg;
    }

    private ClusterSingletonServiceGroup<P, E, C> createGroup(String serviceIdentifier, List<ClusterSingletonServiceRegistration> services) {
        return new ClusterSingletonServiceGroupImpl(serviceIdentifier, this.entityOwnershipService, this.createEntity(SERVICE_ENTITY_TYPE, serviceIdentifier), this.createEntity(CLOSE_SERVICE_ENTITY_TYPE, serviceIdentifier), services);
    }

    private void initializeOrRemoveGroup(ClusterSingletonServiceGroup<P, E, C> group) throws CandidateAlreadyRegisteredException {
        try {
            group.initialize();
        }
        catch (CandidateAlreadyRegisteredException e) {
            this.serviceGroupMap.remove(group.getIdentifier(), group);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRegistration(String serviceIdentifier, ClusterSingletonServiceRegistration reg) {
        PlaceholderGroup placeHolder;
        ListenableFuture<?> future;
        AbstractClusterSingletonServiceProviderImpl abstractClusterSingletonServiceProviderImpl = this;
        synchronized (abstractClusterSingletonServiceProviderImpl) {
            ClusterSingletonServiceGroup lookup = (ClusterSingletonServiceGroup)Verify.verifyNotNull(this.serviceGroupMap.get(serviceIdentifier));
            future = lookup.unregisterService(reg);
            if (future == null) {
                return;
            }
            LOG.debug("Closing service group {}", (Object)serviceIdentifier);
            placeHolder = new PlaceholderGroup(lookup, future);
            String identifier = (String)((ServiceGroupIdentifier)((ClusterSingletonService)reg.getInstance()).getIdentifier()).getValue();
            Verify.verify((boolean)this.serviceGroupMap.replace(identifier, lookup, placeHolder));
            LOG.debug("Replaced group {} with {}", (Object)serviceIdentifier, placeHolder);
            lookup.closeClusterSingletonGroup();
        }
        future.addListener(() -> this.finishShutdown(placeHolder), MoreExecutors.directExecutor());
    }

    synchronized void finishShutdown(PlaceholderGroup<P, E, C> placeHolder) {
        String identifier = placeHolder.getIdentifier();
        LOG.debug("Service group {} closed", (Object)identifier);
        List<ClusterSingletonServiceRegistration> services = placeHolder.getServices();
        if (services.isEmpty()) {
            if (this.serviceGroupMap.remove(identifier, placeHolder)) {
                LOG.debug("Service group {} removed", placeHolder);
            } else {
                LOG.debug("Service group {} superseded by {}", placeHolder, this.serviceGroupMap.get(identifier));
            }
            return;
        }
        ClusterSingletonServiceGroup<P, E, C> group = this.createGroup(identifier, services);
        Verify.verify((boolean)this.serviceGroupMap.replace(identifier, placeHolder, group));
        placeHolder.setSuccessor(group);
        LOG.debug("Service group upgraded from {} to {}", placeHolder, group);
        try {
            this.initializeOrRemoveGroup(group);
        }
        catch (CandidateAlreadyRegisteredException e) {
            LOG.error("Failed to register delayed group {}, it will remain inoperational", (Object)identifier, (Object)e);
        }
    }

    public final void close() {
        LOG.debug("Close method for ClusterSingletonService Provider {}", (Object)this);
        if (this.serviceEntityListenerReg != null) {
            this.serviceEntityListenerReg.close();
            this.serviceEntityListenerReg = null;
        }
        ArrayList listGroupCloseListFuture = new ArrayList();
        for (ClusterSingletonServiceGroup<P, E, C> serviceGroup : this.serviceGroupMap.values()) {
            listGroupCloseListFuture.add(serviceGroup.closeClusterSingletonGroup());
        }
        ListenableFuture finalCloseFuture = Futures.allAsList(listGroupCloseListFuture);
        Futures.addCallback((ListenableFuture)finalCloseFuture, (FutureCallback)new FutureCallback<List<?>>(){

            public void onSuccess(List<?> result) {
                AbstractClusterSingletonServiceProviderImpl.this.cleanup();
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unexpected problem by closing ClusterSingletonServiceProvider {}", (Object)AbstractClusterSingletonServiceProviderImpl.this, (Object)throwable);
                AbstractClusterSingletonServiceProviderImpl.this.cleanup();
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public final void ownershipChanged(C ownershipChange) {
        LOG.debug("Ownership change for ClusterSingletonService Provider {}", ownershipChange);
        String serviceIdentifier = this.getServiceIdentifierFromEntity(ownershipChange.getEntity());
        ClusterSingletonServiceGroup<P, E, C> serviceHolder = this.serviceGroupMap.get(serviceIdentifier);
        if (serviceHolder != null) {
            serviceHolder.ownershipChanged(ownershipChange);
        } else {
            LOG.debug("ClusterSingletonServiceGroup was not found for serviceIdentifier {}", (Object)serviceIdentifier);
        }
    }

    protected abstract R registerListener(String var1, S var2);

    protected abstract E createEntity(String var1, String var2);

    protected abstract String getServiceIdentifierFromEntity(E var1);

    final void cleanup() {
        LOG.debug("Final cleaning ClusterSingletonServiceProvider {}", (Object)this);
        if (this.asyncCloseEntityListenerReg != null) {
            this.asyncCloseEntityListenerReg.close();
            this.asyncCloseEntityListenerReg = null;
        }
        this.serviceGroupMap.clear();
    }
}

