/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.support.impl;

import javax.persistence.EntityManager;
import javax.transaction.RollbackException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.jpa.supplier.EmSupplier;
import org.apache.aries.jpa.support.impl.AbstractJpaTemplate;
import org.apache.aries.jpa.support.xa.impl.TransactionAttribute;
import org.apache.aries.jpa.support.xa.impl.TransactionToken;
import org.apache.aries.jpa.template.EmFunction;
import org.apache.aries.jpa.template.TransactionType;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.Coordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XAJpaTemplate
extends AbstractJpaTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(XAJpaTemplate.class);
    protected EmSupplier emSupplier;
    protected TransactionManager tm;
    private Coordinator coordinator;

    public XAJpaTemplate(EmSupplier emSupplier, TransactionManager tm, Coordinator coordinator) {
        this.emSupplier = emSupplier;
        this.tm = tm;
        this.coordinator = coordinator;
    }

    public <R> R txExpr(TransactionType type, EmFunction<R> code) {
        EntityManager em = null;
        TransactionToken tranToken = null;
        TransactionAttribute ta = TransactionAttribute.fromType(type);
        Coordination coord = null;
        try {
            tranToken = ta.begin(this.tm);
            coord = this.coordinator.begin(this.getClass().getName(), 0L);
            em = this.emSupplier.get();
            if (this.tm.getStatus() != 6) {
                em.joinTransaction();
            }
            Object result = code.apply(em);
            this.safeFinish(tranToken, ta, coord);
            return (R)result;
        }
        catch (RollbackException ex) {
            this.safeRollback(tranToken, ta, coord, ex);
            throw this.wrapThrowable(ex, "RollbackException is propagating");
        }
        catch (Exception ex) {
            this.safeRollback(tranToken, ta, coord, ex);
            throw this.wrapThrowable(ex, "Exception occured in transactional code");
        }
        catch (Error ex) {
            this.safeRollback(tranToken, ta, coord, ex);
            throw ex;
        }
    }

    private static void close(Coordination coord) {
        if (coord != null) {
            coord.end();
        }
    }

    private void safeFinish(TransactionToken tranToken, TransactionAttribute ta, Coordination coord) throws RollbackException {
        try {
            ta.finish(this.tm, tranToken);
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.debug("Exception during finish of transaction", (Throwable)e);
            throw this.wrapThrowable(e, "Exception during finish of transaction");
        }
        XAJpaTemplate.close(coord);
    }

    private void safeRollback(TransactionToken token, TransactionAttribute ta, Coordination coord, Throwable ex) {
        LOGGER.warn("Beginning rollback logic due to exception", ex);
        try {
            Transaction tran = token.getActiveTransaction();
            if (tran != null && XAJpaTemplate.shouldRollback(ex)) {
                LOGGER.info("Rolling back TX due to exception", ex);
                tran.setRollbackOnly();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Exception during transaction rollback", (Throwable)e);
        }
        try {
            this.safeFinish(token, ta, coord);
        }
        catch (RollbackException e) {
            LOGGER.warn("RollbackException during safeFinish attempt for already running safeRollback", (Throwable)e);
        }
    }

    private static boolean shouldRollback(Throwable ex) {
        return ex instanceof RuntimeException || ex instanceof Error;
    }
}

