/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.User;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users.Users;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.users.UsersKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UsersBuilder
implements Builder<Users> {
    private String _description;
    private String _domainid;
    private String _email;
    private String _name;
    private String _password;
    private String _salt;
    private String _userid;
    private Boolean _enabled;
    private UsersKey key;
    Map<Class<? extends Augmentation<Users>>, Augmentation<Users>> augmentation = Collections.emptyMap();

    public UsersBuilder() {
    }

    public UsersBuilder(User arg) {
        this._userid = arg.getUserid();
        this._name = arg.getName();
        this._description = arg.getDescription();
        this._enabled = arg.isEnabled();
        this._email = arg.getEmail();
        this._password = arg.getPassword();
        this._salt = arg.getSalt();
        this._domainid = arg.getDomainid();
    }

    public UsersBuilder(Users base) {
        Map aug;
        this.key = base.key();
        this._userid = base.getUserid();
        this._description = base.getDescription();
        this._domainid = base.getDomainid();
        this._email = base.getEmail();
        this._name = base.getName();
        this._password = base.getPassword();
        this._salt = base.getSalt();
        this._enabled = base.isEnabled();
        if (base instanceof UsersImpl) {
            UsersImpl impl = (UsersImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Users>>, Augmentation<Users>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Users>>, Augmentation<Users>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof User) {
            this._userid = ((User)arg).getUserid();
            this._name = ((User)arg).getName();
            this._description = ((User)arg).getDescription();
            this._enabled = ((User)arg).isEnabled();
            this._email = ((User)arg).getEmail();
            this._password = ((User)arg).getPassword();
            this._salt = ((User)arg).getSalt();
            this._domainid = ((User)arg).getDomainid();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.User]");
    }

    public UsersKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDomainid() {
        return this._domainid;
    }

    public String getEmail() {
        return this._email;
    }

    public String getName() {
        return this._name;
    }

    public String getPassword() {
        return this._password;
    }

    public String getSalt() {
        return this._salt;
    }

    public String getUserid() {
        return this._userid;
    }

    public Boolean isEnabled() {
        return this._enabled;
    }

    public <E$$ extends Augmentation<Users>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public UsersBuilder withKey(UsersKey key) {
        this.key = key;
        return this;
    }

    public UsersBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public UsersBuilder setDomainid(String value) {
        this._domainid = value;
        return this;
    }

    public UsersBuilder setEmail(String value) {
        this._email = value;
        return this;
    }

    public UsersBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public UsersBuilder setPassword(String value) {
        this._password = value;
        return this;
    }

    public UsersBuilder setSalt(String value) {
        this._salt = value;
        return this;
    }

    public UsersBuilder setUserid(String value) {
        this._userid = value;
        return this;
    }

    public UsersBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public UsersBuilder addAugmentation(Class<? extends Augmentation<Users>> augmentationType, Augmentation<Users> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Users>>, Augmentation<Users>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public UsersBuilder removeAugmentation(Class<? extends Augmentation<Users>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Users build() {
        return new UsersImpl(this);
    }

    private static final class UsersImpl
    implements Users {
        private final String _description;
        private final String _domainid;
        private final String _email;
        private final String _name;
        private final String _password;
        private final String _salt;
        private final String _userid;
        private final Boolean _enabled;
        private final UsersKey key;
        private Map<Class<? extends Augmentation<Users>>, Augmentation<Users>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        UsersImpl(UsersBuilder base) {
            this.key = base.key() != null ? base.key() : new UsersKey(base.getUserid());
            this._userid = this.key.getUserid();
            this._description = base.getDescription();
            this._domainid = base.getDomainid();
            this._email = base.getEmail();
            this._name = base.getName();
            this._password = base.getPassword();
            this._salt = base.getSalt();
            this._enabled = base.isEnabled();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Users> getImplementedInterface() {
            return Users.class;
        }

        @Override
        public UsersKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getDomainid() {
            return this._domainid;
        }

        @Override
        public String getEmail() {
            return this._email;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getPassword() {
            return this._password;
        }

        @Override
        public String getSalt() {
            return this._salt;
        }

        @Override
        public String getUserid() {
            return this._userid;
        }

        @Override
        public Boolean isEnabled() {
            return this._enabled;
        }

        public <E$$ extends Augmentation<Users>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._domainid);
            result = 31 * result + Objects.hashCode(this._email);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._password);
            result = 31 * result + Objects.hashCode(this._salt);
            result = 31 * result + Objects.hashCode(this._userid);
            result = 31 * result + Objects.hashCode(this._enabled);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Users.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Users other = (Users)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._domainid, other.getDomainid())) {
                return false;
            }
            if (!Objects.equals(this._email, other.getEmail())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._password, other.getPassword())) {
                return false;
            }
            if (!Objects.equals(this._salt, other.getSalt())) {
                return false;
            }
            if (!Objects.equals(this._userid, other.getUserid())) {
                return false;
            }
            if (!Objects.equals(this._enabled, other.isEnabled())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UsersImpl otherImpl = (UsersImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Users>>, Augmentation<Users>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Users");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_domainid", (Object)this._domainid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_email", (Object)this._email);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_password", (Object)this._password);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_salt", (Object)this._salt);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_userid", (Object)this._userid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_enabled", (Object)this._enabled);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

