/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Role;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles.Roles;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles.RolesKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RolesBuilder
implements Builder<Roles> {
    private String _description;
    private String _domainid;
    private String _name;
    private String _roleid;
    private RolesKey key;
    Map<Class<? extends Augmentation<Roles>>, Augmentation<Roles>> augmentation = Collections.emptyMap();

    public RolesBuilder() {
    }

    public RolesBuilder(Role arg) {
        this._roleid = arg.getRoleid();
        this._name = arg.getName();
        this._description = arg.getDescription();
        this._domainid = arg.getDomainid();
    }

    public RolesBuilder(Roles base) {
        Map aug;
        this.key = base.key();
        this._roleid = base.getRoleid();
        this._description = base.getDescription();
        this._domainid = base.getDomainid();
        this._name = base.getName();
        if (base instanceof RolesImpl) {
            RolesImpl impl = (RolesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Roles>>, Augmentation<Roles>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Roles>>, Augmentation<Roles>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Role) {
            this._roleid = ((Role)arg).getRoleid();
            this._name = ((Role)arg).getName();
            this._description = ((Role)arg).getDescription();
            this._domainid = ((Role)arg).getDomainid();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Role]");
    }

    public RolesKey key() {
        return this.key;
    }

    public String getDescription() {
        return this._description;
    }

    public String getDomainid() {
        return this._domainid;
    }

    public String getName() {
        return this._name;
    }

    public String getRoleid() {
        return this._roleid;
    }

    public <E$$ extends Augmentation<Roles>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public RolesBuilder withKey(RolesKey key) {
        this.key = key;
        return this;
    }

    public RolesBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public RolesBuilder setDomainid(String value) {
        this._domainid = value;
        return this;
    }

    public RolesBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public RolesBuilder setRoleid(String value) {
        this._roleid = value;
        return this;
    }

    public RolesBuilder addAugmentation(Class<? extends Augmentation<Roles>> augmentationType, Augmentation<Roles> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Roles>>, Augmentation<Roles>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RolesBuilder removeAugmentation(Class<? extends Augmentation<Roles>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Roles build() {
        return new RolesImpl(this);
    }

    private static final class RolesImpl
    implements Roles {
        private final String _description;
        private final String _domainid;
        private final String _name;
        private final String _roleid;
        private final RolesKey key;
        private Map<Class<? extends Augmentation<Roles>>, Augmentation<Roles>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        RolesImpl(RolesBuilder base) {
            this.key = base.key() != null ? base.key() : new RolesKey(base.getRoleid());
            this._roleid = this.key.getRoleid();
            this._description = base.getDescription();
            this._domainid = base.getDomainid();
            this._name = base.getName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Roles> getImplementedInterface() {
            return Roles.class;
        }

        @Override
        public RolesKey key() {
            return this.key;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public String getDomainid() {
            return this._domainid;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String getRoleid() {
            return this._roleid;
        }

        public <E$$ extends Augmentation<Roles>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._domainid);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._roleid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Roles.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Roles other = (Roles)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._domainid, other.getDomainid())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._roleid, other.getRoleid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RolesImpl otherImpl = (RolesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Roles>>, Augmentation<Roles>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Roles");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_description", (Object)this._description);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_domainid", (Object)this._domainid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_name", (Object)this._name);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_roleid", (Object)this._roleid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

