/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Grant;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants.Grants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants.GrantsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GrantsBuilder
implements Builder<Grants> {
    private String _domainid;
    private String _grantid;
    private String _roleid;
    private String _userid;
    private GrantsKey key;
    Map<Class<? extends Augmentation<Grants>>, Augmentation<Grants>> augmentation = Collections.emptyMap();

    public GrantsBuilder() {
    }

    public GrantsBuilder(Grant arg) {
        this._grantid = arg.getGrantid();
        this._domainid = arg.getDomainid();
        this._userid = arg.getUserid();
        this._roleid = arg.getRoleid();
    }

    public GrantsBuilder(Grants base) {
        Map aug;
        this.key = base.key();
        this._grantid = base.getGrantid();
        this._domainid = base.getDomainid();
        this._roleid = base.getRoleid();
        this._userid = base.getUserid();
        if (base instanceof GrantsImpl) {
            GrantsImpl impl = (GrantsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Grants>>, Augmentation<Grants>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Grants>>, Augmentation<Grants>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Grant) {
            this._grantid = ((Grant)arg).getGrantid();
            this._domainid = ((Grant)arg).getDomainid();
            this._userid = ((Grant)arg).getUserid();
            this._roleid = ((Grant)arg).getRoleid();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Grant]");
    }

    public GrantsKey key() {
        return this.key;
    }

    public String getDomainid() {
        return this._domainid;
    }

    public String getGrantid() {
        return this._grantid;
    }

    public String getRoleid() {
        return this._roleid;
    }

    public String getUserid() {
        return this._userid;
    }

    public <E$$ extends Augmentation<Grants>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public GrantsBuilder withKey(GrantsKey key) {
        this.key = key;
        return this;
    }

    public GrantsBuilder setDomainid(String value) {
        this._domainid = value;
        return this;
    }

    public GrantsBuilder setGrantid(String value) {
        this._grantid = value;
        return this;
    }

    public GrantsBuilder setRoleid(String value) {
        this._roleid = value;
        return this;
    }

    public GrantsBuilder setUserid(String value) {
        this._userid = value;
        return this;
    }

    public GrantsBuilder addAugmentation(Class<? extends Augmentation<Grants>> augmentationType, Augmentation<Grants> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Grants>>, Augmentation<Grants>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public GrantsBuilder removeAugmentation(Class<? extends Augmentation<Grants>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Grants build() {
        return new GrantsImpl(this);
    }

    private static final class GrantsImpl
    implements Grants {
        private final String _domainid;
        private final String _grantid;
        private final String _roleid;
        private final String _userid;
        private final GrantsKey key;
        private Map<Class<? extends Augmentation<Grants>>, Augmentation<Grants>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        GrantsImpl(GrantsBuilder base) {
            this.key = base.key() != null ? base.key() : new GrantsKey(base.getGrantid());
            this._grantid = this.key.getGrantid();
            this._domainid = base.getDomainid();
            this._roleid = base.getRoleid();
            this._userid = base.getUserid();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Grants> getImplementedInterface() {
            return Grants.class;
        }

        @Override
        public GrantsKey key() {
            return this.key;
        }

        @Override
        public String getDomainid() {
            return this._domainid;
        }

        @Override
        public String getGrantid() {
            return this._grantid;
        }

        @Override
        public String getRoleid() {
            return this._roleid;
        }

        @Override
        public String getUserid() {
            return this._userid;
        }

        public <E$$ extends Augmentation<Grants>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._domainid);
            result = 31 * result + Objects.hashCode(this._grantid);
            result = 31 * result + Objects.hashCode(this._roleid);
            result = 31 * result + Objects.hashCode(this._userid);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Grants.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Grants other = (Grants)obj;
            if (!Objects.equals(this._domainid, other.getDomainid())) {
                return false;
            }
            if (!Objects.equals(this._grantid, other.getGrantid())) {
                return false;
            }
            if (!Objects.equals(this._roleid, other.getRoleid())) {
                return false;
            }
            if (!Objects.equals(this._userid, other.getUserid())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                GrantsImpl otherImpl = (GrantsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Grants>>, Augmentation<Grants>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Grants");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_domainid", (Object)this._domainid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_grantid", (Object)this._grantid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_roleid", (Object)this._roleid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_userid", (Object)this._userid);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

