/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.aaa.app.config.rev170619.AaaAppConfigData;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;

public interface DatastoreConfig
extends ChildOf<AaaAppConfigData>,
Augmentable<DatastoreConfig> {
    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("datastore-config");

    public @Nullable Store getStore();

    public @Nullable BigInteger getTimeToLive();

    public @Nullable BigInteger getTimeToWait();

    public static enum Store implements Enumeration
    {
        H2DataStore(0, "h2-data-store");

        private static final Map<String, Store> NAME_MAP;
        private static final Map<Integer, Store> VALUE_MAP;
        private final String name;
        private final int value;

        private Store(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<Store> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static Store forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (Store enumItem : Store.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

