/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.txchain.TxchainDomWrite;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainDomRead
extends DatastoreAbstractWriter
implements DOMTransactionChainListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainDomRead.class);
    private final DOMDataBroker domDataBroker;

    public TxchainDomRead(DOMDataBroker domDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.domDataBroker = domDataBroker;
        LOG.debug("Created TxchainDomDelete");
    }

    @Override
    public void createList() {
        LOG.debug("TxchainDomDelete: creating data in the data store");
        TxchainDomWrite dd = new TxchainDomWrite(this.domDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        QName olId = QName.create((QName)OuterList.QNAME, (String)"id");
        YangInstanceIdentifier pid = YangInstanceIdentifier.builder().node(TestExec.QNAME).node(OuterList.QNAME).build();
        try (DOMDataTreeReadTransaction tx = this.domDataBroker.newReadOnlyTransaction();){
            for (int l = 0; l < this.outerListElem; ++l) {
                YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifierWithPredicates(OuterList.QNAME, olId, (Object)l));
                FluentFuture submitFuture = tx.read(dsType, yid);
                try {
                    Optional optionalDataObject = (Optional)submitFuture.get();
                    if (optionalDataObject == null || !optionalDataObject.isPresent()) continue;
                    ++this.txOk;
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn("failed to ....", (Throwable)e);
                    ++this.txError;
                }
            }
        }
    }

    public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
        LOG.error("Broken chain {} in TxchainDomDelete, transaction {}, cause {}", new Object[]{chain, transaction.getIdentifier(), cause});
    }

    public void onTransactionChainSuccessful(DOMTransactionChain chain) {
        LOG.debug("TxchainDomDelete closed successfully, chain {}", (Object)chain);
    }
}

