/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ServiceTrackerHelper {
    private static final Logger LOGGER = Logger.getLogger(ServiceTrackerHelper.class.getName());
    private final BundleContext context;

    private ServiceTrackerHelper(BundleContext context) {
        this.context = context;
    }

    public static ServiceTrackerHelper helper(BundleContext bundleContext) {
        return new ServiceTrackerHelper(bundleContext);
    }

    public <S, T extends ServiceTracker> ServiceTracker<S, T> track(Class<S> clazz, Function<S, T> consumer) {
        return this.track(clazz, this.defaultFilter(clazz), consumer, ServiceTracker::close);
    }

    public <S, T extends ServiceTracker> ServiceTracker<S, T> track(Class<S> clazz, String filter, Function<S, T> consumer) {
        return this.track(clazz, filter, consumer, ServiceTracker::close);
    }

    public <S, T> ServiceTracker<S, T> track(Class<S> clazz, Function<S, T> creator, Consumer<T> destroyer) {
        return this.track(clazz, this.defaultFilter(clazz), creator, destroyer);
    }

    public <S, T> ServiceTracker<S, T> track(Class<S> clazz, String filter, final Function<S, T> creator, final Consumer<T> destroyer) {
        if (filter != null) {
            ServiceTracker tracker = new ServiceTracker<S, T>(this.context, this.getOrCreateFilter(filter), null){

                public T addingService(ServiceReference<S> reference) {
                    LOGGER.info("Obtained service dependency: " + this.filter);
                    Object s = this.context.getService(reference);
                    return creator.apply(s);
                }

                public void removedService(ServiceReference<S> reference, T service) {
                    LOGGER.info("Lost service dependency: " + this.filter);
                    destroyer.accept(service);
                    this.context.ungetService(reference);
                }
            };
            tracker.open();
            if (tracker.isEmpty()) {
                LOGGER.info("Waiting for service dependency: " + filter);
            }
            return tracker;
        }
        final T t = creator.apply(null);
        return new ServiceTracker<S, T>(this.context, clazz, null){

            public void close() {
                destroyer.accept(t);
            }
        };
    }

    public <S, T> ServiceTracker<S, T> track(Class<S> clazz, String filter, final BiFunction<S, ServiceReference<S>, T> creator, final Consumer<T> destroyer) {
        if (filter != null) {
            ServiceTracker tracker = new ServiceTracker<S, T>(this.context, this.getOrCreateFilter(filter), null){

                public T addingService(ServiceReference<S> reference) {
                    LOGGER.info("Obtained service dependency: " + this.filter);
                    Object s = this.context.getService(reference);
                    return creator.apply(s, reference);
                }

                public void removedService(ServiceReference<S> reference, T service) {
                    LOGGER.info("Lost service dependency: " + this.filter);
                    destroyer.accept(service);
                    this.context.ungetService(reference);
                }
            };
            tracker.open();
            if (tracker.isEmpty()) {
                LOGGER.info("Waiting for service dependency: " + filter);
            }
            return tracker;
        }
        final T t = creator.apply(null, null);
        return new ServiceTracker<S, T>(this.context, clazz, null){

            public void close() {
                destroyer.accept(t);
            }
        };
    }

    private String defaultFilter(Class<?> clazz) {
        return "(objectClass=" + clazz.getName() + ")";
    }

    private Filter getOrCreateFilter(String filter) {
        try {
            return this.context.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Unable to create filter", e);
        }
    }
}

