/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.UnreservedBandwidth;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.link.attributes.UnreservedBandwidthKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UnreservedBandwidthBuilder
implements Builder<UnreservedBandwidth> {
    private BigDecimal _bandwidth;
    private Short _priority;
    private UnreservedBandwidthKey key;
    Map<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>> augmentation = Collections.emptyMap();

    public UnreservedBandwidthBuilder() {
    }

    public UnreservedBandwidthBuilder(UnreservedBandwidth base) {
        Map aug;
        this.key = base.key();
        this._priority = base.getPriority();
        this._bandwidth = base.getBandwidth();
        if (base instanceof UnreservedBandwidthImpl) {
            UnreservedBandwidthImpl impl = (UnreservedBandwidthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>>(aug);
        }
    }

    public UnreservedBandwidthKey key() {
        return this.key;
    }

    public BigDecimal getBandwidth() {
        return this._bandwidth;
    }

    public Short getPriority() {
        return this._priority;
    }

    public <E$$ extends Augmentation<UnreservedBandwidth>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public UnreservedBandwidthBuilder withKey(UnreservedBandwidthKey key) {
        this.key = key;
        return this;
    }

    public UnreservedBandwidthBuilder setBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._bandwidth = value;
        return this;
    }

    private static void checkPriorityRange(short value) {
        if (value >= 0 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..7]]", (int)value);
    }

    public UnreservedBandwidthBuilder setPriority(Short value) {
        if (value != null) {
            UnreservedBandwidthBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public UnreservedBandwidthBuilder addAugmentation(Class<? extends Augmentation<UnreservedBandwidth>> augmentationType, Augmentation<UnreservedBandwidth> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public UnreservedBandwidthBuilder removeAugmentation(Class<? extends Augmentation<UnreservedBandwidth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public UnreservedBandwidth build() {
        return new UnreservedBandwidthImpl(this);
    }

    private static final class UnreservedBandwidthImpl
    implements UnreservedBandwidth {
        private final BigDecimal _bandwidth;
        private final Short _priority;
        private final UnreservedBandwidthKey key;
        private Map<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        UnreservedBandwidthImpl(UnreservedBandwidthBuilder base) {
            this.key = base.key() != null ? base.key() : new UnreservedBandwidthKey(base.getPriority());
            this._priority = this.key.getPriority();
            this._bandwidth = base.getBandwidth();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<UnreservedBandwidth> getImplementedInterface() {
            return UnreservedBandwidth.class;
        }

        @Override
        public UnreservedBandwidthKey key() {
            return this.key;
        }

        @Override
        public BigDecimal getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public Short getPriority() {
            return this._priority;
        }

        public <E$$ extends Augmentation<UnreservedBandwidth>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._priority);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UnreservedBandwidth.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UnreservedBandwidth other = (UnreservedBandwidth)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UnreservedBandwidthImpl otherImpl = (UnreservedBandwidthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UnreservedBandwidth>>, Augmentation<UnreservedBandwidth>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"UnreservedBandwidth");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_bandwidth", (Object)this._bandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_priority", (Object)this._priority);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

