/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.TimeDivisionMultiplexCapable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TimeDivisionMultiplexCapableBuilder
implements Builder<TimeDivisionMultiplexCapable> {
    private Integer _indication;
    private BigDecimal _minimumLspBandwidth;
    Map<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>> augmentation = Collections.emptyMap();

    public TimeDivisionMultiplexCapableBuilder() {
    }

    public TimeDivisionMultiplexCapableBuilder(TimeDivisionMultiplexCapable base) {
        Map aug;
        this._indication = base.getIndication();
        this._minimumLspBandwidth = base.getMinimumLspBandwidth();
        if (base instanceof TimeDivisionMultiplexCapableImpl) {
            TimeDivisionMultiplexCapableImpl impl = (TimeDivisionMultiplexCapableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>>(aug);
        }
    }

    public Integer getIndication() {
        return this._indication;
    }

    public BigDecimal getMinimumLspBandwidth() {
        return this._minimumLspBandwidth;
    }

    public <E$$ extends Augmentation<TimeDivisionMultiplexCapable>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkIndicationRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public TimeDivisionMultiplexCapableBuilder setIndication(Integer value) {
        if (value != null) {
            TimeDivisionMultiplexCapableBuilder.checkIndicationRange(value);
        }
        this._indication = value;
        return this;
    }

    public TimeDivisionMultiplexCapableBuilder setMinimumLspBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._minimumLspBandwidth = value;
        return this;
    }

    public TimeDivisionMultiplexCapableBuilder addAugmentation(Class<? extends Augmentation<TimeDivisionMultiplexCapable>> augmentationType, Augmentation<TimeDivisionMultiplexCapable> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TimeDivisionMultiplexCapableBuilder removeAugmentation(Class<? extends Augmentation<TimeDivisionMultiplexCapable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public TimeDivisionMultiplexCapable build() {
        return new TimeDivisionMultiplexCapableImpl(this);
    }

    private static final class TimeDivisionMultiplexCapableImpl
    implements TimeDivisionMultiplexCapable {
        private final Integer _indication;
        private final BigDecimal _minimumLspBandwidth;
        private Map<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TimeDivisionMultiplexCapableImpl(TimeDivisionMultiplexCapableBuilder base) {
            this._indication = base.getIndication();
            this._minimumLspBandwidth = base.getMinimumLspBandwidth();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TimeDivisionMultiplexCapable> getImplementedInterface() {
            return TimeDivisionMultiplexCapable.class;
        }

        @Override
        public Integer getIndication() {
            return this._indication;
        }

        @Override
        public BigDecimal getMinimumLspBandwidth() {
            return this._minimumLspBandwidth;
        }

        public <E$$ extends Augmentation<TimeDivisionMultiplexCapable>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._indication);
            result = 31 * result + Objects.hashCode(this._minimumLspBandwidth);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TimeDivisionMultiplexCapable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TimeDivisionMultiplexCapable other = (TimeDivisionMultiplexCapable)obj;
            if (!Objects.equals(this._indication, other.getIndication())) {
                return false;
            }
            if (!Objects.equals(this._minimumLspBandwidth, other.getMinimumLspBandwidth())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TimeDivisionMultiplexCapableImpl otherImpl = (TimeDivisionMultiplexCapableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TimeDivisionMultiplexCapable>>, Augmentation<TimeDivisionMultiplexCapable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"TimeDivisionMultiplexCapable");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_indication", (Object)this._indication);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_minimumLspBandwidth", (Object)this._minimumLspBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

