/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.srlg.attributes._interface.switching.capabilities.PacketSwitchCapable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PacketSwitchCapableBuilder
implements Builder<PacketSwitchCapable> {
    private Integer _interfaceMtu;
    private BigDecimal _minimumLspBandwidth;
    Map<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>> augmentation = Collections.emptyMap();

    public PacketSwitchCapableBuilder() {
    }

    public PacketSwitchCapableBuilder(PacketSwitchCapable base) {
        Map aug;
        this._interfaceMtu = base.getInterfaceMtu();
        this._minimumLspBandwidth = base.getMinimumLspBandwidth();
        if (base instanceof PacketSwitchCapableImpl) {
            PacketSwitchCapableImpl impl = (PacketSwitchCapableImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>>(aug);
        }
    }

    public Integer getInterfaceMtu() {
        return this._interfaceMtu;
    }

    public BigDecimal getMinimumLspBandwidth() {
        return this._minimumLspBandwidth;
    }

    public <E$$ extends Augmentation<PacketSwitchCapable>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkInterfaceMtuRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (int)value);
    }

    public PacketSwitchCapableBuilder setInterfaceMtu(Integer value) {
        if (value != null) {
            PacketSwitchCapableBuilder.checkInterfaceMtuRange(value);
        }
        this._interfaceMtu = value;
        return this;
    }

    public PacketSwitchCapableBuilder setMinimumLspBandwidth(BigDecimal value) {
        if (value != null) {
            // empty if block
        }
        this._minimumLspBandwidth = value;
        return this;
    }

    public PacketSwitchCapableBuilder addAugmentation(Class<? extends Augmentation<PacketSwitchCapable>> augmentationType, Augmentation<PacketSwitchCapable> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PacketSwitchCapableBuilder removeAugmentation(Class<? extends Augmentation<PacketSwitchCapable>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PacketSwitchCapable build() {
        return new PacketSwitchCapableImpl(this);
    }

    private static final class PacketSwitchCapableImpl
    implements PacketSwitchCapable {
        private final Integer _interfaceMtu;
        private final BigDecimal _minimumLspBandwidth;
        private Map<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        PacketSwitchCapableImpl(PacketSwitchCapableBuilder base) {
            this._interfaceMtu = base.getInterfaceMtu();
            this._minimumLspBandwidth = base.getMinimumLspBandwidth();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PacketSwitchCapable> getImplementedInterface() {
            return PacketSwitchCapable.class;
        }

        @Override
        public Integer getInterfaceMtu() {
            return this._interfaceMtu;
        }

        @Override
        public BigDecimal getMinimumLspBandwidth() {
            return this._minimumLspBandwidth;
        }

        public <E$$ extends Augmentation<PacketSwitchCapable>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._interfaceMtu);
            result = 31 * result + Objects.hashCode(this._minimumLspBandwidth);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PacketSwitchCapable.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PacketSwitchCapable other = (PacketSwitchCapable)obj;
            if (!Objects.equals(this._interfaceMtu, other.getInterfaceMtu())) {
                return false;
            }
            if (!Objects.equals(this._minimumLspBandwidth, other.getMinimumLspBandwidth())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PacketSwitchCapableImpl otherImpl = (PacketSwitchCapableImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PacketSwitchCapable>>, Augmentation<PacketSwitchCapable>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PacketSwitchCapable");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_interfaceMtu", (Object)this._interfaceMtu);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_minimumLspBandwidth", (Object)this._minimumLspBandwidth);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

