/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yanglib.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.ModulesState;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.ModulesStateBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.RevisionUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.Module;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.ModuleBuilder;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.library.rev160621.module.list.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.YangIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.yanglib.impl.rev141210.YanglibConfig;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.PotentialSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaListenerRegistration;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceListener;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceRegistry;
import org.opendaylight.yangtools.yang.model.repo.util.FilesystemSchemaSourceCache;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YangLibProvider
implements AutoCloseable,
SchemaSourceListener {
    private static final Logger LOG = LoggerFactory.getLogger(YangLibProvider.class);
    private static final Predicate<PotentialSchemaSource<?>> YANG_SCHEMA_SOURCE = input -> YangTextSchemaSource.class.isAssignableFrom(input.getRepresentation());
    private final DataBroker dataBroker;
    private final YanglibConfig yanglibConfig;
    private final SharedSchemaRepository schemaRepository;
    private SchemaListenerRegistration schemaListenerRegistration;

    public YangLibProvider(YanglibConfig yanglibConfig, DataBroker dataBroker, SharedSchemaRepository schemaRepository) {
        this.yanglibConfig = (YanglibConfig)Preconditions.checkNotNull((Object)yanglibConfig);
        this.dataBroker = (DataBroker)Preconditions.checkNotNull((Object)dataBroker);
        this.schemaRepository = (SharedSchemaRepository)Preconditions.checkNotNull((Object)schemaRepository);
    }

    @Override
    public void close() {
        if (this.schemaListenerRegistration != null) {
            this.schemaListenerRegistration.close();
        }
    }

    public void init() {
        if (Strings.isNullOrEmpty((String)this.yanglibConfig.getCacheFolder())) {
            LOG.info("No cache-folder set in yanglib-config - yang library services will not be available");
            return;
        }
        File cacheFolderFile = new File(this.yanglibConfig.getCacheFolder());
        Preconditions.checkArgument((boolean)cacheFolderFile.exists(), (String)"cache-folder %s does not exist", (Object)cacheFolderFile);
        Preconditions.checkArgument((boolean)cacheFolderFile.isDirectory(), (String)"cache-folder %s is not a directory", (Object)cacheFolderFile);
        FilesystemSchemaSourceCache cache = new FilesystemSchemaSourceCache((SchemaSourceRegistry)this.schemaRepository, YangTextSchemaSource.class, cacheFolderFile);
        this.schemaRepository.registerSchemaSourceListener((SchemaSourceListener)cache);
        this.schemaListenerRegistration = this.schemaRepository.registerSchemaSourceListener((SchemaSourceListener)this);
        LOG.info("Started yang library with sources from {}", (Object)cacheFolderFile);
    }

    public void schemaSourceEncountered(SchemaSourceRepresentation source) {
    }

    public void schemaSourceRegistered(Iterable<PotentialSchemaSource<?>> sources) {
        ArrayList<Module> newModules = new ArrayList<Module>();
        for (PotentialSchemaSource potentialYangSource : Iterables.filter(sources, YANG_SCHEMA_SOURCE)) {
            YangIdentifier moduleName = new YangIdentifier(potentialYangSource.getSourceIdentifier().getName());
            Module newModule = new ModuleBuilder().setName(moduleName).setRevision(RevisionUtils.fromYangCommon((Optional)potentialYangSource.getSourceIdentifier().getRevision())).setSchema(this.getUrlForModule(potentialYangSource.getSourceIdentifier())).build();
            newModules.add(newModule);
        }
        if (newModules.isEmpty()) {
            return;
        }
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.merge(LogicalDatastoreType.OPERATIONAL, InstanceIdentifier.create(ModulesState.class), (DataObject)new ModulesStateBuilder().setModule(newModules).build());
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(@Nullable CommitInfo result) {
                LOG.debug("Modules state successfully populated with new modules");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to update modules state", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    public void schemaSourceUnregistered(PotentialSchemaSource<?> source) {
        if (!YANG_SCHEMA_SOURCE.apply(source)) {
            return;
        }
        WriteTransaction tx = this.dataBroker.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, (InstanceIdentifier)InstanceIdentifier.create(ModulesState.class).child(Module.class, (Identifier)new ModuleKey(new YangIdentifier(source.getSourceIdentifier().getName()), RevisionUtils.fromYangCommon((Optional)source.getSourceIdentifier().getRevision()))));
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(@Nullable CommitInfo result) {
                LOG.debug("Modules state successfully updated.");
            }

            public void onFailure(Throwable throwable) {
                LOG.warn("Unable to update modules state", throwable);
            }
        }, MoreExecutors.directExecutor());
    }

    private Uri getUrlForModule(SourceIdentifier sourceIdentifier) {
        return new Uri("http://" + this.yanglibConfig.getBindingAddr() + ':' + this.yanglibConfig.getBindingPort() + "/yanglib/schemas/" + sourceIdentifier.getName() + '/' + YangLibProvider.revString(sourceIdentifier));
    }

    private static String revString(SourceIdentifier id) {
        return id.getRevision().map(Revision::toString).orElse("");
    }
}

