/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jpa.impl.descriptor;

import java.net.URL;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.ops4j.lang.Ops4jException;
import org.ops4j.pax.jpa.impl.JpaWeavingHook;
import org.ops4j.pax.jpa.impl.PersistenceUnitState;
import org.ops4j.pax.jpa.impl.TemporaryBundleClassLoader;
import org.ops4j.pax.jpa.jaxb.Persistence;
import org.ops4j.pax.jpa.jaxb.PersistenceUnitCachingType;
import org.ops4j.pax.jpa.jaxb.PersistenceUnitTransactionType;
import org.ops4j.pax.jpa.jaxb.PersistenceUnitValidationModeType;
import org.ops4j.pax.swissbox.core.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.weaving.WeavingHook;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private Bundle bundle;
    private String version;
    private Persistence.PersistenceUnit persistenceUnit;
    private DataSourceFactory dataSourceFactory;
    private Properties props;
    private BundleClassLoader cl;
    private PersistenceProvider provider;
    private ServiceRegistration<EntityManagerFactoryBuilder> emfBuilderRegistration;
    private ServiceRegistration<EntityManagerFactory> emfRegistration;
    private ServiceRegistration<WeavingHook> hookRegistration;
    private PersistenceUnitState state;

    public PersistenceUnitInfoImpl(Bundle bundle, String version, Persistence.PersistenceUnit persistenceUnit, Properties props) {
        this.bundle = bundle;
        this.version = version;
        this.persistenceUnit = persistenceUnit;
        this.props = props;
        this.state = PersistenceUnitState.UNASSIGNED;
        this.cl = new BundleClassLoader(bundle);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnit.getName();
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceUnit.getProvider();
    }

    public javax.persistence.spi.PersistenceUnitTransactionType getTransactionType() {
        PersistenceUnitTransactionType transactionType = this.persistenceUnit.getTransactionType();
        return transactionType == null ? null : javax.persistence.spi.PersistenceUnitTransactionType.valueOf((String)transactionType.toString());
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public DataSource getNonJtaDataSource() {
        String dataSourceName = this.persistenceUnit.getNonJtaDataSource();
        if (dataSourceName != null) {
            try {
                InitialContext context = new InitialContext();
                DataSource dataSource = (DataSource)context.lookup(dataSourceName);
                return dataSource;
            }
            catch (NamingException exc) {
                throw new Ops4jException((Throwable)exc);
            }
        }
        String url = this.props.getProperty("javax.persistence.jdbc.url");
        String user = this.props.getProperty("javax.persistence.jdbc.user");
        String password = this.props.getProperty("javax.persistence.jdbc.password");
        Properties dsfProps = new Properties();
        if (url != null) {
            dsfProps.setProperty("url", url);
        }
        if (user != null) {
            dsfProps.setProperty("user", user);
        }
        if (password != null) {
            dsfProps.setProperty("password", password);
        }
        try {
            return this.dataSourceFactory.createDataSource(dsfProps);
        }
        catch (SQLException exc) {
            throw new Ops4jException((Throwable)exc);
        }
    }

    public List<String> getMappingFileNames() {
        return this.persistenceUnit.getMappingFile();
    }

    public List<URL> getJarFileUrls() {
        return Collections.emptyList();
    }

    public URL getPersistenceUnitRootUrl() {
        return this.bundle.getEntry("/");
    }

    public List<String> getManagedClassNames() {
        return this.persistenceUnit.getClazz();
    }

    public boolean excludeUnlistedClasses() {
        Boolean exclude = this.persistenceUnit.isExcludeUnlistedClasses();
        return exclude == null ? false : exclude;
    }

    public SharedCacheMode getSharedCacheMode() {
        PersistenceUnitCachingType sharedCacheMode = this.persistenceUnit.getSharedCacheMode();
        return sharedCacheMode == null ? null : SharedCacheMode.valueOf((String)sharedCacheMode.toString());
    }

    public ValidationMode getValidationMode() {
        PersistenceUnitValidationModeType validationMode = this.persistenceUnit.getValidationMode();
        return validationMode == null ? null : ValidationMode.valueOf((String)validationMode.toString());
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.version;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void addTransformer(ClassTransformer transformer) {
        JpaWeavingHook hook = new JpaWeavingHook(this, transformer);
        this.hookRegistration = this.bundle.getBundleContext().registerService(WeavingHook.class, (Object)hook, null);
    }

    public ClassLoader getNewTempClassLoader() {
        return new TemporaryBundleClassLoader(this.bundle, this.provider.getClass().getClassLoader());
    }

    public PersistenceProvider getProvider() {
        return this.provider;
    }

    public void setProvider(PersistenceProvider provider) {
        this.provider = provider;
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    public ServiceRegistration<EntityManagerFactory> getEmfRegistration() {
        return this.emfRegistration;
    }

    public void setEmfRegistration(ServiceRegistration<EntityManagerFactory> emfRegistration) {
        this.emfRegistration = emfRegistration;
    }

    public ServiceRegistration<EntityManagerFactoryBuilder> getEmfBuilderRegistration() {
        return this.emfBuilderRegistration;
    }

    public void setEmfBuilderRegistration(ServiceRegistration<EntityManagerFactoryBuilder> emfBuilderRegistration) {
        this.emfBuilderRegistration = emfBuilderRegistration;
    }

    public void unregister() {
        this.state = PersistenceUnitState.UNASSIGNED;
        this.unregister(this.emfBuilderRegistration);
        this.unregister(this.emfRegistration);
        this.unregister(this.hookRegistration);
        this.emfBuilderRegistration = null;
        this.emfRegistration = null;
        this.hookRegistration = null;
    }

    private <T> void unregister(ServiceRegistration<T> reg) {
        try {
            if (reg != null) {
                reg.unregister();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public PersistenceUnitState getState() {
        return this.state;
    }

    public void setState(PersistenceUnitState state) {
        this.state = state;
    }

    public boolean hasJndiDataSource() {
        return this.persistenceUnit.getNonJtaDataSource() != null;
    }
}

