/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodesBuilder
implements Builder<Nodes> {
    private List<Node> _node;
    Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();

    public NodesBuilder() {
    }

    public NodesBuilder(Nodes base) {
        Map aug;
        this._node = base.getNode();
        if (base instanceof NodesImpl) {
            NodesImpl impl = (NodesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(aug);
        }
    }

    public List<Node> getNode() {
        return this._node;
    }

    public <E$$ extends Augmentation<Nodes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public NodesBuilder setNode(List<Node> values) {
        this._node = values;
        return this;
    }

    public NodesBuilder addAugmentation(Class<? extends Augmentation<Nodes>> augmentationType, Augmentation<Nodes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NodesBuilder removeAugmentation(Class<? extends Augmentation<Nodes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Nodes build() {
        return new NodesImpl(this);
    }

    private static final class NodesImpl
    implements Nodes {
        private final List<Node> _node;
        private Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodesImpl(NodesBuilder base) {
            this._node = base.getNode();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Nodes> getImplementedInterface() {
            return Nodes.class;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        public <E$$ extends Augmentation<Nodes>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Nodes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Nodes other = (Nodes)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NodesImpl otherImpl = (NodesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Nodes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_node", this._node);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

