/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.isis.node.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.isis.node.attributes.Ted;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.PccCapabilities;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.node.attributes.Ipv4LocalAddress;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.ted.node.attributes.Ipv6LocalAddress;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TedBuilder
implements Builder<Ted> {
    private List<Ipv4LocalAddress> _ipv4LocalAddress;
    private List<Ipv6LocalAddress> _ipv6LocalAddress;
    private PccCapabilities _pccCapabilities;
    private Ipv4Address _teRouterIdIpv4;
    private Ipv6Address _teRouterIdIpv6;
    Map<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> augmentation = Collections.emptyMap();

    public TedBuilder() {
    }

    public TedBuilder(TedNodeAttributes arg) {
        this._teRouterIdIpv4 = arg.getTeRouterIdIpv4();
        this._teRouterIdIpv6 = arg.getTeRouterIdIpv6();
        this._ipv4LocalAddress = arg.getIpv4LocalAddress();
        this._ipv6LocalAddress = arg.getIpv6LocalAddress();
        this._pccCapabilities = arg.getPccCapabilities();
    }

    public TedBuilder(Ted base) {
        Map aug;
        this._ipv4LocalAddress = base.getIpv4LocalAddress();
        this._ipv6LocalAddress = base.getIpv6LocalAddress();
        this._pccCapabilities = base.getPccCapabilities();
        this._teRouterIdIpv4 = base.getTeRouterIdIpv4();
        this._teRouterIdIpv6 = base.getTeRouterIdIpv6();
        if (base instanceof TedImpl) {
            TedImpl impl = (TedImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TedNodeAttributes) {
            this._teRouterIdIpv4 = ((TedNodeAttributes)arg).getTeRouterIdIpv4();
            this._teRouterIdIpv6 = ((TedNodeAttributes)arg).getTeRouterIdIpv6();
            this._ipv4LocalAddress = ((TedNodeAttributes)arg).getIpv4LocalAddress();
            this._ipv6LocalAddress = ((TedNodeAttributes)arg).getIpv6LocalAddress();
            this._pccCapabilities = ((TedNodeAttributes)arg).getPccCapabilities();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.ted.rev131021.TedNodeAttributes]");
    }

    public List<Ipv4LocalAddress> getIpv4LocalAddress() {
        return this._ipv4LocalAddress;
    }

    public List<Ipv6LocalAddress> getIpv6LocalAddress() {
        return this._ipv6LocalAddress;
    }

    public PccCapabilities getPccCapabilities() {
        return this._pccCapabilities;
    }

    public Ipv4Address getTeRouterIdIpv4() {
        return this._teRouterIdIpv4;
    }

    public Ipv6Address getTeRouterIdIpv6() {
        return this._teRouterIdIpv6;
    }

    public <E$$ extends Augmentation<Ted>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public TedBuilder setIpv4LocalAddress(List<Ipv4LocalAddress> values) {
        this._ipv4LocalAddress = values;
        return this;
    }

    public TedBuilder setIpv6LocalAddress(List<Ipv6LocalAddress> values) {
        this._ipv6LocalAddress = values;
        return this;
    }

    public TedBuilder setPccCapabilities(PccCapabilities value) {
        this._pccCapabilities = value;
        return this;
    }

    public TedBuilder setTeRouterIdIpv4(Ipv4Address value) {
        this._teRouterIdIpv4 = value;
        return this;
    }

    public TedBuilder setTeRouterIdIpv6(Ipv6Address value) {
        this._teRouterIdIpv6 = value;
        return this;
    }

    public TedBuilder addAugmentation(Class<? extends Augmentation<Ted>> augmentationType, Augmentation<Ted> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Ted>>, Augmentation<Ted>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TedBuilder removeAugmentation(Class<? extends Augmentation<Ted>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Ted build() {
        return new TedImpl(this);
    }

    private static final class TedImpl
    implements Ted {
        private final List<Ipv4LocalAddress> _ipv4LocalAddress;
        private final List<Ipv6LocalAddress> _ipv6LocalAddress;
        private final PccCapabilities _pccCapabilities;
        private final Ipv4Address _teRouterIdIpv4;
        private final Ipv6Address _teRouterIdIpv6;
        private Map<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        TedImpl(TedBuilder base) {
            this._ipv4LocalAddress = base.getIpv4LocalAddress();
            this._ipv6LocalAddress = base.getIpv6LocalAddress();
            this._pccCapabilities = base.getPccCapabilities();
            this._teRouterIdIpv4 = base.getTeRouterIdIpv4();
            this._teRouterIdIpv6 = base.getTeRouterIdIpv6();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Ted> getImplementedInterface() {
            return Ted.class;
        }

        public List<Ipv4LocalAddress> getIpv4LocalAddress() {
            return this._ipv4LocalAddress;
        }

        public List<Ipv6LocalAddress> getIpv6LocalAddress() {
            return this._ipv6LocalAddress;
        }

        public PccCapabilities getPccCapabilities() {
            return this._pccCapabilities;
        }

        public Ipv4Address getTeRouterIdIpv4() {
            return this._teRouterIdIpv4;
        }

        public Ipv6Address getTeRouterIdIpv6() {
            return this._teRouterIdIpv6;
        }

        public <E$$ extends Augmentation<Ted>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipv4LocalAddress);
            result = 31 * result + Objects.hashCode(this._ipv6LocalAddress);
            result = 31 * result + Objects.hashCode(this._pccCapabilities);
            result = 31 * result + Objects.hashCode(this._teRouterIdIpv4);
            result = 31 * result + Objects.hashCode(this._teRouterIdIpv6);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Ted.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Ted other = (Ted)obj;
            if (!Objects.equals(this._ipv4LocalAddress, other.getIpv4LocalAddress())) {
                return false;
            }
            if (!Objects.equals(this._ipv6LocalAddress, other.getIpv6LocalAddress())) {
                return false;
            }
            if (!Objects.equals(this._pccCapabilities, other.getPccCapabilities())) {
                return false;
            }
            if (!Objects.equals(this._teRouterIdIpv4, other.getTeRouterIdIpv4())) {
                return false;
            }
            if (!Objects.equals(this._teRouterIdIpv6, other.getTeRouterIdIpv6())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TedImpl otherImpl = (TedImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Ted>>, Augmentation<Ted>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Ted");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipv4LocalAddress", this._ipv4LocalAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipv6LocalAddress", this._ipv6LocalAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_pccCapabilities", (Object)this._pccCapabilities);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_teRouterIdIpv4", (Object)this._teRouterIdIpv4);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_teRouterIdIpv6", (Object)this._teRouterIdIpv6);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

