/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.IsoNetId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.IsisNodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.isis.node.attributes.Iso;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.isis.node.attributes.RouterType;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.node.attributes.isis.node.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IsisNodeAttributesBuilder
implements Builder<IsisNodeAttributes> {
    private Iso _iso;
    private List<Short> _multiTopologyId;
    private List<IsoNetId> _net;
    private RouterType _routerType;
    private Ted _ted;
    Map<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>> augmentation = Collections.emptyMap();

    public IsisNodeAttributesBuilder() {
    }

    public IsisNodeAttributesBuilder(IsisNodeAttributes base) {
        Map aug;
        this._iso = base.getIso();
        this._multiTopologyId = base.getMultiTopologyId();
        this._net = base.getNet();
        this._routerType = base.getRouterType();
        this._ted = base.getTed();
        if (base instanceof IsisNodeAttributesImpl) {
            IsisNodeAttributesImpl impl = (IsisNodeAttributesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>>(aug);
        }
    }

    public Iso getIso() {
        return this._iso;
    }

    public List<Short> getMultiTopologyId() {
        return this._multiTopologyId;
    }

    public List<IsoNetId> getNet() {
        return this._net;
    }

    public RouterType getRouterType() {
        return this._routerType;
    }

    public Ted getTed() {
        return this._ted;
    }

    public <E$$ extends Augmentation<IsisNodeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public IsisNodeAttributesBuilder setIso(Iso value) {
        this._iso = value;
        return this;
    }

    private static void checkMultiTopologyIdRange(short value) {
        if (value >= 0 && value <= 127) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..127]]", (int)value);
    }

    public IsisNodeAttributesBuilder setMultiTopologyId(List<Short> values) {
        if (values != null) {
            for (Short value : values) {
                IsisNodeAttributesBuilder.checkMultiTopologyIdRange(value);
            }
        }
        this._multiTopologyId = values;
        return this;
    }

    public IsisNodeAttributesBuilder setNet(List<IsoNetId> values) {
        this._net = values;
        return this;
    }

    public IsisNodeAttributesBuilder setRouterType(RouterType value) {
        this._routerType = value;
        return this;
    }

    public IsisNodeAttributesBuilder setTed(Ted value) {
        this._ted = value;
        return this;
    }

    public IsisNodeAttributesBuilder addAugmentation(Class<? extends Augmentation<IsisNodeAttributes>> augmentationType, Augmentation<IsisNodeAttributes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IsisNodeAttributesBuilder removeAugmentation(Class<? extends Augmentation<IsisNodeAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IsisNodeAttributes build() {
        return new IsisNodeAttributesImpl(this);
    }

    private static final class IsisNodeAttributesImpl
    implements IsisNodeAttributes {
        private final Iso _iso;
        private final List<Short> _multiTopologyId;
        private final List<IsoNetId> _net;
        private final RouterType _routerType;
        private final Ted _ted;
        private Map<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IsisNodeAttributesImpl(IsisNodeAttributesBuilder base) {
            this._iso = base.getIso();
            this._multiTopologyId = base.getMultiTopologyId();
            this._net = base.getNet();
            this._routerType = base.getRouterType();
            this._ted = base.getTed();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IsisNodeAttributes> getImplementedInterface() {
            return IsisNodeAttributes.class;
        }

        @Override
        public Iso getIso() {
            return this._iso;
        }

        @Override
        public List<Short> getMultiTopologyId() {
            return this._multiTopologyId;
        }

        @Override
        public List<IsoNetId> getNet() {
            return this._net;
        }

        @Override
        public RouterType getRouterType() {
            return this._routerType;
        }

        @Override
        public Ted getTed() {
            return this._ted;
        }

        public <E$$ extends Augmentation<IsisNodeAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._iso);
            result = 31 * result + Objects.hashCode(this._multiTopologyId);
            result = 31 * result + Objects.hashCode(this._net);
            result = 31 * result + Objects.hashCode(this._routerType);
            result = 31 * result + Objects.hashCode(this._ted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IsisNodeAttributes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IsisNodeAttributes other = (IsisNodeAttributes)obj;
            if (!Objects.equals(this._iso, other.getIso())) {
                return false;
            }
            if (!Objects.equals(this._multiTopologyId, other.getMultiTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._net, other.getNet())) {
                return false;
            }
            if (!Objects.equals(this._routerType, other.getRouterType())) {
                return false;
            }
            if (!Objects.equals(this._ted, other.getTed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IsisNodeAttributesImpl otherImpl = (IsisNodeAttributesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IsisNodeAttributes>>, Augmentation<IsisNodeAttributes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IsisNodeAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_iso", (Object)this._iso);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_multiTopologyId", this._multiTopologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_net", this._net);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_routerType", (Object)this._routerType);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ted", (Object)this._ted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

