/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.link.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.link.attributes.IsisLinkAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.isis.topology.rev131021.isis.link.attributes.isis.link.attributes.Ted;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class IsisLinkAttributesBuilder
implements Builder<IsisLinkAttributes> {
    private Short _multiTopologyId;
    private Ted _ted;
    Map<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>> augmentation = Collections.emptyMap();

    public IsisLinkAttributesBuilder() {
    }

    public IsisLinkAttributesBuilder(IsisLinkAttributes base) {
        Map aug;
        this._multiTopologyId = base.getMultiTopologyId();
        this._ted = base.getTed();
        if (base instanceof IsisLinkAttributesImpl) {
            IsisLinkAttributesImpl impl = (IsisLinkAttributesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>>(aug);
        }
    }

    public Short getMultiTopologyId() {
        return this._multiTopologyId;
    }

    public Ted getTed() {
        return this._ted;
    }

    public <E$$ extends Augmentation<IsisLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMultiTopologyIdRange(short value) {
        if (value >= 0 && value <= 127) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..127]]", (int)value);
    }

    public IsisLinkAttributesBuilder setMultiTopologyId(Short value) {
        if (value != null) {
            IsisLinkAttributesBuilder.checkMultiTopologyIdRange(value);
        }
        this._multiTopologyId = value;
        return this;
    }

    public IsisLinkAttributesBuilder setTed(Ted value) {
        this._ted = value;
        return this;
    }

    public IsisLinkAttributesBuilder addAugmentation(Class<? extends Augmentation<IsisLinkAttributes>> augmentationType, Augmentation<IsisLinkAttributes> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public IsisLinkAttributesBuilder removeAugmentation(Class<? extends Augmentation<IsisLinkAttributes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public IsisLinkAttributes build() {
        return new IsisLinkAttributesImpl(this);
    }

    private static final class IsisLinkAttributesImpl
    implements IsisLinkAttributes {
        private final Short _multiTopologyId;
        private final Ted _ted;
        private Map<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        IsisLinkAttributesImpl(IsisLinkAttributesBuilder base) {
            this._multiTopologyId = base.getMultiTopologyId();
            this._ted = base.getTed();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<IsisLinkAttributes> getImplementedInterface() {
            return IsisLinkAttributes.class;
        }

        @Override
        public Short getMultiTopologyId() {
            return this._multiTopologyId;
        }

        @Override
        public Ted getTed() {
            return this._ted;
        }

        public <E$$ extends Augmentation<IsisLinkAttributes>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._multiTopologyId);
            result = 31 * result + Objects.hashCode(this._ted);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!IsisLinkAttributes.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            IsisLinkAttributes other = (IsisLinkAttributes)obj;
            if (!Objects.equals(this._multiTopologyId, other.getMultiTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._ted, other.getTed())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                IsisLinkAttributesImpl otherImpl = (IsisLinkAttributesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<IsisLinkAttributes>>, Augmentation<IsisLinkAttributes>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"IsisLinkAttributes");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_multiTopologyId", (Object)this._multiTopologyId);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ted", (Object)this._ted);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

