/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.web.env;

import javax.servlet.Filter;
import javax.servlet.ServletContextListener;
import org.apache.shiro.web.env.EnvironmentLoaderListener;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.opendaylight.aaa.shiro.filters.AAAShiroFilter;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.WebContextBuilder;
import org.opendaylight.aaa.web.WebContextSecurer;

public class ShiroWebContextSecurer
implements WebContextSecurer {
    private final EnvironmentLoaderListener shiroEnvironmentLoaderListener;

    public ShiroWebContextSecurer(EnvironmentLoaderListener shiroEnvironmentLoaderListener) {
        this.shiroEnvironmentLoaderListener = shiroEnvironmentLoaderListener;
    }

    public void requireAuthentication(WebContextBuilder webContextBuilder, String ... urlPatterns) {
        webContextBuilder.addListener((ServletContextListener)this.shiroEnvironmentLoaderListener).addFilter(FilterDetails.builder().filter((Filter)new AAAShiroFilter()).addUrlPatterns(urlPatterns).build()).addFilter(FilterDetails.builder().filter((Filter)new CrossOriginFilter()).addUrlPatterns(urlPatterns).putInitParam("allowedOrigins", "*").putInitParam("allowedMethods", "GET,POST,OPTIONS,DELETE,PUT,HEAD").putInitParam("allowedHeaders", "origin, content-type, accept, authorization").build());
    }
}

