/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.tokenauthrealm.auth;

import java.util.Objects;
import org.opendaylight.aaa.api.PasswordCredentials;

public class PasswordCredentialBuilder {
    private final MutablePasswordCredentials pc = new MutablePasswordCredentials();

    public PasswordCredentialBuilder setUserName(String username) {
        this.pc.username = username;
        return this;
    }

    public PasswordCredentialBuilder setPassword(String password) {
        this.pc.password = password;
        return this;
    }

    public PasswordCredentialBuilder setDomain(String domain) {
        this.pc.domain = domain;
        return this;
    }

    public PasswordCredentials build() {
        return this.pc;
    }

    private static class MutablePasswordCredentials
    implements PasswordCredentials {
        private int hashCode = 0;
        private String username;
        private String password;
        private String domain;

        private MutablePasswordCredentials() {
        }

        public String username() {
            return this.username;
        }

        public String password() {
            return this.password;
        }

        public String domain() {
            return this.domain;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PasswordCredentials)) {
                return false;
            }
            PasswordCredentials passwordCredentials = (PasswordCredentials)object;
            return Objects.equals(this.username, passwordCredentials.username()) && Objects.equals(this.password, passwordCredentials.password()) && Objects.equals(this.domain, passwordCredentials.domain());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Objects.hash(this.username, this.password, this.domain);
            }
            return this.hashCode;
        }
    }
}

