/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.tokenauthrealm.auth;

import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.Claim;
import org.opendaylight.aaa.shiro.tokenauthrealm.auth.ClaimBuilder;

public class AuthenticationBuilder {
    private long expiration = 0L;
    private final Claim claim;

    public AuthenticationBuilder(Claim claim) {
        this.claim = claim;
    }

    public AuthenticationBuilder setExpiration(long expiration) {
        this.expiration = expiration;
        return this;
    }

    public Authentication build() {
        return new ImmutableAuthentication(this);
    }

    private static final class ImmutableAuthentication
    implements Authentication,
    Serializable {
        private static final long serialVersionUID = 4919078164955609987L;
        private int hashCode = 0;
        long expiration = 0L;
        Claim claim;

        private ImmutableAuthentication(AuthenticationBuilder base) {
            if (base.claim == null) {
                throw new IllegalStateException("The Claim is null.");
            }
            this.claim = new ClaimBuilder(base.claim).build();
            this.expiration = base.expiration;
            if (base.expiration < 0L) {
                throw new IllegalStateException("The expiration is less than 0.");
            }
        }

        public long expiration() {
            return this.expiration;
        }

        public String clientId() {
            return this.claim.clientId();
        }

        public String userId() {
            return this.claim.userId();
        }

        public String user() {
            return this.claim.user();
        }

        public String domain() {
            return this.claim.domain();
        }

        public Set<String> roles() {
            return this.claim.roles();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Authentication)) {
                return false;
            }
            Authentication authentication = (Authentication)object;
            return this.expiration == authentication.expiration() && Objects.equals(this.claim.roles(), authentication.roles()) && Objects.equals(this.claim.domain(), authentication.domain()) && Objects.equals(this.claim.userId(), authentication.userId()) && Objects.equals(this.claim.user(), authentication.user()) && Objects.equals(this.claim.clientId(), authentication.clientId());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = Objects.hash(this.expiration, this.claim);
            }
            return this.hashCode;
        }

        public String toString() {
            return "expiration:" + this.expiration + "," + this.claim.toString();
        }
    }
}

