/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm.util.http;

import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.opendaylight.aaa.shiro.realm.util.http.SimpleHttpRequest;

public class SimpleHttpClient {
    private final Client client;

    private SimpleHttpClient(Client client) {
        this.client = client;
    }

    public static Builder clientBuilder() {
        return new Builder();
    }

    public <T> SimpleHttpRequest.Builder<T> requestBuilder(Class<T> outputType) {
        return new SimpleHttpRequest.Builder<T>(this.client, outputType);
    }

    public static class Builder {
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private final Set<Class<?>> providers = new HashSet();

        private Builder() {
        }

        public Builder sslContext(SSLContext context) {
            this.sslContext = context;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier verifier) {
            this.hostnameVerifier = verifier;
            return this;
        }

        public Builder provider(Class<?> provider) {
            this.providers.add(provider);
            return this;
        }

        public SimpleHttpClient build() {
            ClientConfig clientConfig = new ClientConfig();
            this.providers.forEach(arg_0 -> ((ClientConfig)clientConfig).register(arg_0));
            Client client = ClientBuilder.newBuilder().sslContext(this.sslContext).hostnameVerifier(this.hostnameVerifier).withConfig((Configuration)clientConfig).build();
            return new SimpleHttpClient(client);
        }
    }
}

