/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.ldap.DefaultLdapRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.realm.ldap.LdapUtils;
import org.apache.shiro.subject.PrincipalCollection;
import org.opendaylight.aaa.shiro.realm.mapping.api.GroupsToRolesMappingStrategy;
import org.opendaylight.aaa.shiro.realm.mapping.impl.BestAttemptGroupToRolesMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODLJndiLdapRealm
extends DefaultLdapRealm {
    private static final Logger LOG = LoggerFactory.getLogger(ODLJndiLdapRealm.class);
    private static final String DEFAULT_LDAP_ATTRIBUTE_FOR_COMPARISON = "objectClass";
    private static final String UID = "uid";
    private static final String ROLE_NAMES_DELIMITER = ",";
    private static final GroupsToRolesMappingStrategy GROUPS_TO_ROLES_MAPPING_STRATEGY = new BestAttemptGroupToRolesMappingStrategy();
    private String searchBase = super.getUserDnSuffix();
    private String ldapAttributeForComparison = "objectClass";
    private Map<String, String> groupRolesMap;

    public ODLJndiLdapRealm() {
        LOG.debug("Creating ODLJndiLdapRealm");
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        try {
            String username = ODLJndiLdapRealm.getUsername(token);
            this.logIncomingConnection(username);
            return super.doGetAuthenticationInfo(token);
        }
        catch (ClassCastException e) {
            LOG.info("Couldn't service the LDAP connection", (Throwable)e);
            return null;
        }
    }

    protected void logIncomingConnection(String username) {
        LOG.info("AAA LDAP connection from {}", (Object)username);
    }

    public static String getUsername(AuthenticationToken token) throws ClassCastException {
        if (null == token) {
            return null;
        }
        return (String)token.getPrincipal();
    }

    protected String getUsername(PrincipalCollection principals) throws ClassCastException {
        if (null == principals) {
            return null;
        }
        return (String)this.getAvailablePrincipal(principals);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthorizationInfo ai = null;
        try {
            ai = this.queryForAuthorizationInfo(principals, this.getContextFactory());
        }
        catch (NamingException e) {
            LOG.error("Unable to query for AuthZ info", (Throwable)e);
        }
        return ai;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection principals, LdapContextFactory ldapContextFactory) throws NamingException {
        AuthorizationInfo authorizationInfo = null;
        try {
            String username = this.getUsername(principals);
            LdapContext ldapContext = ldapContextFactory.getSystemLdapContext();
            try {
                Set<String> roleNames = this.getRoleNamesForUser(username, ldapContext);
                authorizationInfo = ODLJndiLdapRealm.buildAuthorizationInfo(roleNames);
            }
            finally {
                LdapUtils.closeContext((LdapContext)ldapContext);
            }
        }
        catch (ClassCastException e) {
            LOG.error("Unable to extract a valid user", (Throwable)e);
        }
        return authorizationInfo;
    }

    public static AuthorizationInfo buildAuthorizationInfo(Set<String> roleNames) {
        if (null == roleNames) {
            return null;
        }
        return new SimpleAuthorizationInfo(roleNames);
    }

    protected Set<String> getRoleNamesForUser(String username, LdapContext ldapContext) throws NamingException {
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchControls = ODLJndiLdapRealm.createSearchControls();
        LOG.debug("Asking the configured LDAP about which groups uid=\"{}\" belongs to using searchBase=\"{}\" ldapAttributeForComparison=\"{}\"", new Object[]{username, this.searchBase, this.ldapAttributeForComparison});
        NamingEnumeration<SearchResult> answer = ldapContext.search(this.searchBase, String.format("%s=%s", UID, username), searchControls);
        while (answer.hasMoreElements()) {
            SearchResult searchResult = answer.next();
            Attributes attrs = searchResult.getAttributes();
            if (attrs == null) continue;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMore()) {
                Collection<String> roleNamesFromLdapGroups;
                Attribute attr = ae.next();
                LOG.debug("LDAP returned \"{}\" attribute for \"{}\"", (Object)attr.getID(), (Object)username);
                if (!attr.getID().equals(this.ldapAttributeForComparison)) continue;
                Collection groupNamesExtractedFromLdap = LdapUtils.getAllAttributeValues((Attribute)attr);
                Map<String, Set<String>> groupsToRoles = GROUPS_TO_ROLES_MAPPING_STRATEGY.mapGroupsToRoles(groupNamesExtractedFromLdap, ROLE_NAMES_DELIMITER, this.groupRolesMap);
                if (this.groupRolesMap != null) {
                    roleNamesFromLdapGroups = new HashSet();
                    for (Set<String> set : groupsToRoles.values()) {
                        roleNamesFromLdapGroups.addAll(set);
                    }
                    if (LOG.isDebugEnabled()) {
                        for (Map.Entry entry : groupsToRoles.entrySet()) {
                            LOG.debug("Mapped the \"{}\" LDAP group to \"{}\" ODL role for \"{}\"", new Object[]{entry.getKey(), entry.getValue(), username});
                        }
                    }
                } else {
                    LOG.debug("Since groupRolesMap was unspecified, no mapping is attempted so the role names are set to the extracted group names");
                    roleNamesFromLdapGroups = groupNamesExtractedFromLdap;
                    if (LOG.isDebugEnabled()) {
                        for (String string : groupNamesExtractedFromLdap) {
                            LOG.debug("Mapped the \"{}\" LDAP group to \"{}\" ODL role for \"{}\"", new Object[]{string, string, username});
                        }
                    }
                }
                roleNames.addAll(roleNamesFromLdapGroups);
            }
        }
        return roleNames;
    }

    protected static SearchControls createSearchControls() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        return searchControls;
    }

    public String getUserDnSuffix() {
        return super.getUserDnSuffix();
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setLdapAttributeForComparison(String ldapAttributeForComparison) {
        this.ldapAttributeForComparison = ldapAttributeForComparison;
    }

    public void setGroupRolesMap(Map<String, String> groupRolesMap) {
        this.groupRolesMap = groupRolesMap;
    }
}

