/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.realm;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.glassfish.jersey.client.ClientConfig;
import org.opendaylight.aaa.shiro.moon.MoonPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoonRealm
extends AuthorizingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(MoonRealm.class);
    private static final String MOON_DEFAULT_DOMAIN = "sdn";
    private URL moonServerURL;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken upt;
        String username;
        String domain = MOON_DEFAULT_DOMAIN;
        try {
            username = (String)authenticationToken.getPrincipal();
        }
        catch (ClassCastException e) {
            LOG.debug("doGetAuthenticationInfo() failed because the principal couldn't be cast as a String", (Throwable)e);
            throw e;
        }
        try {
            upt = (UsernamePasswordToken)authenticationToken;
        }
        catch (ClassCastException e) {
            LOG.debug("doGetAuthenticationInfo() failed because the token was not a UsernamePasswordToken", (Throwable)e);
            throw e;
        }
        String password = new String(upt.getPassword());
        MoonPrincipal moonPrincipal = this.moonAuthenticate(username, password, MOON_DEFAULT_DOMAIN);
        if (moonPrincipal != null) {
            return new SimpleAuthenticationInfo((Object)moonPrincipal, (Object)password.toCharArray(), this.getName());
        }
        return null;
    }

    public MoonPrincipal moonAuthenticate(String username, String password, String domain) {
        int portFromShiro;
        String hostFromShiro;
        ClientConfig config = new ClientConfig();
        Client client = ClientBuilder.newClient((Configuration)config);
        String string = hostFromShiro = this.moonServerURL != null ? this.moonServerURL.getHost() : null;
        if (hostFromShiro == null) {
            LOG.debug("moon server was not specified appropriately, cannot authenticate");
            return null;
        }
        String server = hostFromShiro;
        int n = portFromShiro = this.moonServerURL != null ? this.moonServerURL.getPort() : -1;
        if (portFromShiro <= 0) {
            LOG.debug("moon server was not specified appropriately, cannot authetnicate");
            return null;
        }
        String port = Integer.toString(portFromShiro);
        String url = String.format("http://%s:%s/moon/auth/tokens", server, port);
        LOG.debug("Moon server is at: {}:{} and will be accessed through {}", new Object[]{server, port, url});
        WebTarget webTarget = client.target(url);
        String input = "{\"username\": \"" + username + "\",\"password\":\"" + password + "\",\"project\":\"" + domain + "\"}";
        String output = (String)webTarget.request(new String[]{"application/json"}).post(Entity.entity((Object)input, (String)"application/json"), String.class);
        JsonElement element = new JsonParser().parse(output);
        if (!element.isJsonObject()) {
            throw new IllegalStateException("Authentication error: returned output is not a JSON object");
        }
        JsonObject object = element.getAsJsonObject();
        JsonObject error = object.get("error").getAsJsonObject();
        if (error != null) {
            throw new IllegalStateException("Authentication Error : " + error.get("title").getAsString());
        }
        JsonElement token = object.get("token");
        if (token == null) {
            return null;
        }
        String tokenValue = token.getAsString();
        String userID = username + "@" + domain;
        LinkedHashSet<String> userRoles = new LinkedHashSet<String>();
        JsonElement roles = object.get("roles");
        if (roles != null) {
            for (JsonElement role : roles.getAsJsonArray()) {
                try {
                    userRoles.add(role.getAsString());
                }
                catch (ClassCastException e) {
                    LOG.debug("Unable to cast role as String, skipping {}", (Object)role, (Object)e);
                }
            }
        }
        return new MoonPrincipal(username, domain, userID, userRoles, tokenValue);
    }

    public void setMoonServerURL(String moonServerURL) {
        try {
            this.moonServerURL = new URL(moonServerURL);
        }
        catch (MalformedURLException e) {
            LOG.warn("The moon server URL could not be parsed", (Throwable)e);
        }
    }
}

