/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.shiro.idm;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opendaylight.aaa.api.ClaimCache;
import org.opendaylight.aaa.api.IDMStoreException;
import org.opendaylight.aaa.api.IIDMStore;
import org.opendaylight.aaa.api.model.IDMError;
import org.opendaylight.aaa.api.model.User;
import org.opendaylight.aaa.api.model.Users;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/users")
public class UserHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UserHandler.class);
    private static final String DEFAULT_PWD = "changeme";
    private static final String REDACTED_PASSWORD = "**********";
    private static final String REDACTED_SALT = "**********";
    private static final String DEFAULT_DESCRIPTION = "";
    private static final String DEFAULT_EMAIL = "";
    private final IIDMStore iidMStore;
    private final ClaimCache claimCache;

    public UserHandler(IIDMStore iidMStore, ClaimCache claimCache) {
        this.iidMStore = iidMStore;
        this.claimCache = claimCache;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getUsers() {
        LOG.info("GET /auth/v1/users  (extracts all users)");
        try {
            Users users = this.iidMStore.getUsers();
            List usersList = users.getUsers();
            for (User user : usersList) {
                UserHandler.redactUserPasswordInfo(user);
            }
            return Response.ok((Object)users).build();
        }
        catch (IDMStoreException se) {
            return this.internalError("getting", (Exception)((Object)se));
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getUser(@PathParam(value="id") String id) {
        LOG.info("GET auth/v1/users/ {}  (extract user with specified id)", (Object)id);
        try {
            User user = this.iidMStore.readUser(id);
            if (user == null) {
                String error = "user not found! id: " + id;
                return new IDMError(404, error, "").response();
            }
            UserHandler.redactUserPasswordInfo(user);
            return Response.ok((Object)user).build();
        }
        catch (IDMStoreException se) {
            return this.internalError("getting", (Exception)((Object)se));
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createUser(@Context UriInfo info, User user) {
        String userName;
        LOG.info("POST /auth/v1/users  (create a user with the specified payload");
        if (user.getUserid() != null) {
            String errorMessage = "do not specify userId, it will be assigned automatically for you";
            LOG.debug("do not specify userId, it will be assigned automatically for you");
            IDMError idmError = new IDMError();
            idmError.setMessage("do not specify userId, it will be assigned automatically for you");
            return Response.status((int)400).entity((Object)idmError).build();
        }
        if (user.isEnabled() == null) {
            user.setEnabled(true);
        }
        if ((userName = user.getName()) == null) {
            return this.missingRequiredField("name");
        }
        if (userName.length() > 256) {
            return this.providedFieldTooLong("name", 256);
        }
        String domainId = user.getDomainid();
        if (domainId == null) {
            return this.missingRequiredField("domain");
        }
        if (domainId.length() > 256) {
            return this.providedFieldTooLong("domain", 256);
        }
        String userDescription = user.getDescription();
        if (userDescription == null) {
            user.setDescription("");
        } else if (userDescription.length() > 256) {
            return this.providedFieldTooLong("description", 256);
        }
        String userEmail = user.getEmail();
        if (userEmail == null) {
            user.setEmail("");
        } else if (userEmail.length() > 256) {
            return this.providedFieldTooLong("email", 256);
        }
        String userPassword = user.getPassword();
        if (userPassword == null) {
            user.setPassword(DEFAULT_PWD);
        } else if (userPassword.length() > 256) {
            return this.providedFieldTooLong("password", 256);
        }
        try {
            User createdUser = this.iidMStore.writeUser(user);
            user.setUserid(createdUser.getUserid());
        }
        catch (IDMStoreException se) {
            return this.internalError("creating", (Exception)((Object)se));
        }
        UserHandler.redactUserPasswordInfo(user);
        return Response.status((int)201).entity((Object)user).build();
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putUser(@Context UriInfo info, User user, @PathParam(value="id") String id) {
        LOG.info("PUT /auth/v1/users/{}  (Updates a user account)", (Object)id);
        try {
            user.setUserid(id);
            if (this.checkInputFieldLength(user.getPassword())) {
                return this.providedFieldTooLong("password", 256);
            }
            if (this.checkInputFieldLength(user.getName())) {
                return this.providedFieldTooLong("name", 256);
            }
            if (this.checkInputFieldLength(user.getDescription())) {
                return this.providedFieldTooLong("description", 256);
            }
            if (this.checkInputFieldLength(user.getEmail())) {
                return this.providedFieldTooLong("email", 256);
            }
            if (this.checkInputFieldLength(user.getDomainid())) {
                return this.providedFieldTooLong("domain", 256);
            }
            if ((user = this.iidMStore.updateUser(user)) == null) {
                return new IDMError(404, String.format("User not found for id %s", id), "").response();
            }
            this.claimCache.clear();
            UserHandler.redactUserPasswordInfo(user);
            return Response.status((int)200).entity((Object)user).build();
        }
        catch (IDMStoreException se) {
            return this.internalError("updating", (Exception)((Object)se));
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteUser(@Context UriInfo info, @PathParam(value="id") String id) {
        LOG.info("DELETE /auth/v1/users/{}  (Delete a user account)", (Object)id);
        try {
            User user = this.iidMStore.deleteUser(id);
            if (user == null) {
                return new IDMError(404, String.format("Error deleting user.  Couldn't find user with id %s", id), "").response();
            }
        }
        catch (IDMStoreException se) {
            return this.internalError("deleting", (Exception)((Object)se));
        }
        this.claimCache.clear();
        return Response.status((int)204).build();
    }

    private Response internalError(String verbal, Exception ex) {
        LOG.error("There was an internal error {} the user", (Object)verbal, (Object)ex);
        return new IDMError(500, String.format("There was an internal error %s the user", verbal)).response();
    }

    private Response missingRequiredField(String fieldName) {
        return new IDMError(400, String.format("%s is required to create the user account.  Please provide a %s in your payload.", fieldName, fieldName), "").response();
    }

    private Response providedFieldTooLong(String fieldName, int maxFieldLength) {
        return new IDMError(400, UserHandler.getProvidedFieldTooLongMessage(fieldName, maxFieldLength), "").response();
    }

    private static String getProvidedFieldTooLongMessage(String fieldName, int maxFieldLength) {
        return String.format("The provided %s field is too long.  The max length is %s.", fieldName, maxFieldLength);
    }

    private static void redactUserPasswordInfo(User user) {
        user.setPassword("**********");
        user.setSalt("**********");
    }

    private boolean checkInputFieldLength(String inputField) {
        return inputField != null && inputField.length() > 256;
    }
}

