/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.datastore.h2;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.opendaylight.aaa.api.Authentication;
import org.opendaylight.aaa.api.TokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2TokenStore
implements AutoCloseable,
TokenStore {
    private static final Logger LOG = LoggerFactory.getLogger(H2TokenStore.class);
    private static final String TOKEN_CACHE_MANAGER = "org.opendaylight.aaa";
    private static final String TOKEN_CACHE = "tokens";
    private int maxCachedTokensInMemory = 10000;
    private int maxCachedTokensOnDisk = 100000;
    private final Cache tokens;

    public H2TokenStore(long secondsToLive, long secondsToIdle) {
        Cache existingCache;
        CacheManager cm = CacheManager.getCacheManager((String)TOKEN_CACHE_MANAGER);
        if (cm == null) {
            Configuration configuration = ConfigurationFactory.parseConfiguration();
            configuration.setName(TOKEN_CACHE_MANAGER);
            cm = CacheManager.newInstance((Configuration)configuration);
        }
        if ((existingCache = cm.getCache(TOKEN_CACHE)) != null) {
            this.tokens = existingCache;
        } else {
            this.tokens = new Cache(new CacheConfiguration(TOKEN_CACHE, this.maxCachedTokensInMemory).maxEntriesLocalDisk(this.maxCachedTokensOnDisk).timeToLiveSeconds(secondsToLive).timeToIdleSeconds(secondsToIdle));
            cm.addCache(this.tokens);
        }
        LOG.info("Initialized token store with default cache config");
    }

    @Override
    public void close() {
        LOG.info("Shutting down token store...");
        CacheManager.getInstance().shutdown();
    }

    public Authentication get(String token) {
        Element elem = this.tokens.get((Serializable)((Object)token));
        return (Authentication)(elem != null ? elem.getObjectValue() : null);
    }

    public void put(String token, Authentication auth) {
        this.tokens.put(new Element((Object)token, (Object)auth));
    }

    public boolean delete(String token) {
        return this.tokens.remove((Serializable)((Object)token));
    }

    public long tokenExpiration() {
        return this.tokens.getCacheConfiguration().getTimeToLiveSeconds();
    }
}

