/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.function.Consumer;
import org.apache.aries.blueprint.container.AbstractServiceReferenceRecipe;
import org.apache.aries.blueprint.container.SatisfiableRecipe;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.opendaylight.controller.blueprint.ext.MandatoryServiceReferenceMetadata;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StaticServiceReferenceRecipe
extends AbstractServiceReferenceRecipe {
    private static final Logger LOG = LoggerFactory.getLogger(StaticServiceReferenceRecipe.class);
    private static final SatisfiableRecipe.SatisfactionListener NOOP_LISTENER = satisfiable -> {};
    private volatile ServiceReference<?> trackedServiceReference;
    private volatile Object trackedService;
    private Consumer<Object> serviceSatisfiedCallback;

    StaticServiceReferenceRecipe(String name, ExtendedBlueprintContainer blueprintContainer, String interfaceClass) {
        super(name, blueprintContainer, (ServiceReferenceMetadata)new MandatoryServiceReferenceMetadata(name, interfaceClass), null, null, Collections.emptyList());
    }

    void startTracking(Consumer<Object> newServiceSatisfiedCallback) {
        this.serviceSatisfiedCallback = newServiceSatisfiedCallback;
        super.start(NOOP_LISTENER);
    }

    protected void track(ServiceReference reference) {
        this.retrack();
    }

    protected void untrack(ServiceReference reference) {
        LOG.debug("{}: In untrack {}", (Object)this.getName(), (Object)reference);
        if (this.trackedServiceReference == reference) {
            LOG.debug("{}: Current reference {} has been untracked", (Object)this.getName(), this.trackedServiceReference);
        }
    }

    protected void retrack() {
        LOG.debug("{}: In retrack", (Object)this.getName());
        if (this.trackedServiceReference == null) {
            this.trackedServiceReference = this.getBestServiceReference();
            LOG.debug("{}: getBestServiceReference: {}", (Object)this.getName(), this.trackedServiceReference);
            if (this.trackedServiceReference != null && this.serviceSatisfiedCallback != null) {
                this.serviceSatisfiedCallback.accept(this.internalCreate());
            }
        }
    }

    protected void doStop() {
        LOG.debug("{}: In doStop", (Object)this.getName());
        if (this.trackedServiceReference != null && this.trackedService != null) {
            try {
                this.getBundleContextForServiceLookup().ungetService(this.trackedServiceReference);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.trackedServiceReference = null;
            this.trackedService = null;
        }
    }

    protected Object internalCreate() throws ComponentDefinitionException {
        ServiceReference<?> localTrackedServiceReference = this.trackedServiceReference;
        LOG.debug("{}: In internalCreate: trackedServiceReference: {}", (Object)this.getName(), localTrackedServiceReference);
        if (this.trackedService != null) {
            return this.trackedService;
        }
        Preconditions.checkNotNull(localTrackedServiceReference, (Object)"trackedServiceReference is null");
        this.trackedService = this.getServiceSecurely(localTrackedServiceReference);
        LOG.debug("{}: Returning service instance: {}", (Object)this.getName(), this.trackedService);
        Preconditions.checkNotNull((Object)this.trackedService, (String)"getService() returned null for %s", localTrackedServiceReference);
        return this.trackedService;
    }

    public boolean isStaticLifecycle() {
        return true;
    }
}

