/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import java.util.Arrays;
import java.util.List;
import org.apache.aries.blueprint.ext.ComponentFactoryMetadata;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.opendaylight.controller.blueprint.ext.RpcImplementationBean;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutedRpcMetadata
implements ComponentFactoryMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(RoutedRpcMetadata.class);
    static final String ROUTED_RPC_IMPLEMENTATION = "routed-rpc-implementation";
    private final String id;
    private final String interfaceName;
    private final String implementationRefId;
    private ExtendedBlueprintContainer container;

    RoutedRpcMetadata(String id, String interfaceName, String implementationRefId) {
        this.id = id;
        this.interfaceName = interfaceName;
        this.implementationRefId = implementationRefId;
    }

    public String getId() {
        return this.id;
    }

    public int getActivation() {
        return 2;
    }

    public List<String> getDependsOn() {
        return Arrays.asList("org.opendaylight.blueprint.RpcRegistry", this.implementationRefId);
    }

    public void init(ExtendedBlueprintContainer newContainer) {
        this.container = newContainer;
        LOG.debug("{}: In init", (Object)this.logName());
    }

    public Object create() throws ComponentDefinitionException {
        RpcProviderRegistry rpcRegistry = (RpcProviderRegistry)this.container.getComponentInstance("org.opendaylight.blueprint.RpcRegistry");
        Object implementation = this.container.getComponentInstance(this.implementationRefId);
        try {
            if (!RpcService.class.isAssignableFrom(implementation.getClass())) {
                throw new ComponentDefinitionException(String.format("Implementation \"ref\" instance %s for \"%s\" is not an RpcService", implementation.getClass(), ROUTED_RPC_IMPLEMENTATION));
            }
            List<Class<RpcService>> rpcInterfaces = RpcImplementationBean.getImplementedRpcServiceInterfaces(this.interfaceName, implementation.getClass(), this.container.getBundleContext().getBundle(), ROUTED_RPC_IMPLEMENTATION);
            if (rpcInterfaces.size() > 1) {
                throw new ComponentDefinitionException(String.format("Implementation \"ref\" instance %s for \"%s\" implements more than one RpcService interface (%s). Please specify the exact \"interface\"", implementation.getClass(), ROUTED_RPC_IMPLEMENTATION, rpcInterfaces));
            }
            Class<RpcService> rpcInterface = rpcInterfaces.iterator().next();
            LOG.debug("{}: create - adding routed implementation {} for RpcService {}", new Object[]{this.logName(), implementation, rpcInterface});
            return rpcRegistry.addRoutedRpcImplementation(rpcInterface, (RpcService)implementation);
        }
        catch (ComponentDefinitionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ComponentDefinitionException(String.format("Error processing \"%s\" for %s", ROUTED_RPC_IMPLEMENTATION, implementation.getClass()), (Throwable)e);
        }
    }

    public void destroy(Object instance) {
        LOG.debug("{}: In destroy: instance: {}", (Object)this.logName(), instance);
        ((BindingAwareBroker.RoutedRpcRegistration)instance).close();
    }

    private String logName() {
        return (this.container != null ? this.container.getBundleContext().getBundle().getSymbolicName() : "") + " (" + this.id + ")";
    }
}

