/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlParserStream;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class BindingContext {
    private static String GET_KEY_METHOD = "key";
    public final InstanceIdentifier<DataObject> appConfigPath;
    public final Class<DataObject> appConfigBindingClass;
    public final Class<? extends DataSchemaNode> schemaType;
    public final QName bindingQName;

    public static BindingContext create(String logName, Class<? extends DataObject> klass, String appConfigListKeyValue) {
        if (Identifiable.class.isAssignableFrom(klass)) {
            if (Strings.isNullOrEmpty((String)appConfigListKeyValue)) {
                throw new ComponentDefinitionException(String.format("%s: App config binding class %s represents a yang list therefore \"%s\" must be specified", logName, klass.getName(), "list-key-value"));
            }
            try {
                return ListBindingContext.newInstance(klass, appConfigListKeyValue);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new ComponentDefinitionException(String.format("%s: Error initializing for app config list binding class %s", logName, klass.getName()), (Throwable)e);
            }
        }
        return new ContainerBindingContext(klass);
    }

    private BindingContext(Class<DataObject> appConfigBindingClass, InstanceIdentifier<DataObject> appConfigPath, Class<? extends DataSchemaNode> schemaType) {
        this.appConfigBindingClass = appConfigBindingClass;
        this.appConfigPath = appConfigPath;
        this.schemaType = schemaType;
        this.bindingQName = BindingReflections.findQName(appConfigBindingClass);
    }

    public NormalizedNode<?, ?> parseDataElement(Element element, DataSchemaNode dataSchema, SchemaContext schemaContext) throws XMLStreamException, IOException, ParserConfigurationException, SAXException, URISyntaxException {
        NormalizedNodeResult resultHolder = new NormalizedNodeResult();
        NormalizedNodeStreamWriter writer = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)resultHolder);
        XmlParserStream xmlParser = XmlParserStream.create((NormalizedNodeStreamWriter)writer, (SchemaContext)schemaContext, (SchemaNode)dataSchema);
        xmlParser.traverse(new DOMSource(element));
        NormalizedNode result = resultHolder.getResult();
        if (result instanceof MapNode) {
            MapNode mapNode = (MapNode)result;
            MapEntryNode mapEntryNode = (MapEntryNode)mapNode.getValue().iterator().next();
            return mapEntryNode;
        }
        return result;
    }

    public abstract NormalizedNode<?, ?> newDefaultNode(DataSchemaNode var1);

    private static class ListBindingContext
    extends BindingContext {
        final String appConfigListKeyValue;

        ListBindingContext(Class<? extends DataObject> appConfigBindingClass, InstanceIdentifier<? extends DataObject> appConfigPath, String appConfigListKeyValue) {
            super(appConfigBindingClass, appConfigPath, ListSchemaNode.class);
            this.appConfigListKeyValue = appConfigListKeyValue;
        }

        private static ListBindingContext newInstance(Class<? extends DataObject> bindingClass, String listKeyValue) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Identifier keyInstance = (Identifier)bindingClass.getMethod(GET_KEY_METHOD, new Class[0]).getReturnType().getConstructor(String.class).newInstance(listKeyValue);
            InstanceIdentifier appConfigPath = InstanceIdentifier.builder(bindingClass, (Identifier)keyInstance).build();
            return new ListBindingContext(bindingClass, (InstanceIdentifier<? extends DataObject>)appConfigPath, listKeyValue);
        }

        @Override
        public NormalizedNode<?, ?> newDefaultNode(DataSchemaNode dataSchema) {
            List keys = ((ListSchemaNode)dataSchema).getKeyDefinition();
            Preconditions.checkArgument((keys.size() == 1 ? 1 : 0) != 0, (String)"Expected only 1 key for list %s", (Object)this.appConfigBindingClass);
            QName listKeyQName = (QName)keys.get(0);
            return ImmutableNodes.mapEntryBuilder((QName)this.bindingQName, (QName)listKeyQName, (Object)this.appConfigListKeyValue).build();
        }
    }

    private static class ContainerBindingContext
    extends BindingContext {
        ContainerBindingContext(Class<? extends DataObject> appConfigBindingClass) {
            super(appConfigBindingClass, InstanceIdentifier.create(appConfigBindingClass), ContainerSchemaNode.class);
        }

        @Override
        public NormalizedNode<?, ?> newDefaultNode(DataSchemaNode dataSchema) {
            return ImmutableNodes.containerNode((QName)this.bindingQName);
        }
    }
}

