/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.opendaylight.controller.blueprint.ext.AbstractDependentComponentFactoryMetadata;
import org.opendaylight.controller.blueprint.ext.RpcUtil;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.spi.RpcRoutingStrategy;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.osgi.service.blueprint.container.ComponentDefinitionException;

abstract class AbstractInvokableServiceMetadata
extends AbstractDependentComponentFactoryMetadata {
    private final String interfaceName;
    private ListenerRegistration<DOMRpcAvailabilityListener> rpcListenerReg;
    private RpcConsumerRegistry rpcRegistry;
    private Class<RpcService> rpcInterface;
    private Set<SchemaPath> rpcSchemaPaths;

    AbstractInvokableServiceMetadata(String id, String interfaceName) {
        super(id);
        this.interfaceName = (String)Preconditions.checkNotNull((Object)interfaceName);
    }

    Class<RpcService> rpcInterface() {
        return this.rpcInterface;
    }

    @Override
    public final void init(ExtendedBlueprintContainer container) {
        Class interfaceClass;
        super.init(container);
        try {
            interfaceClass = this.container().getBundleContext().getBundle().loadClass(this.interfaceName);
        }
        catch (Exception e) {
            throw new ComponentDefinitionException(String.format("%s: Error obtaining interface class %s", this.logName(), this.interfaceName), (Throwable)e);
        }
        if (!RpcService.class.isAssignableFrom(interfaceClass)) {
            throw new ComponentDefinitionException(String.format("%s: The specified interface %s is not an RpcService", this.logName(), this.interfaceName));
        }
        this.rpcInterface = interfaceClass;
    }

    @Override
    protected final void startTracking() {
        this.retrieveService("RpcConsumerRegistry", RpcConsumerRegistry.class, this::onRpcRegistry);
    }

    private void onRpcRegistry(Object service) {
        this.log.debug("{}: Retrieved RpcProviderRegistry {}", (Object)this.logName(), service);
        this.rpcRegistry = (RpcConsumerRegistry)service;
        this.retrieveService("SchemaService", DOMSchemaService.class, this::onSchemaService);
    }

    private void onSchemaService(Object service) {
        this.log.debug("{}: Retrieved SchemaService {}", (Object)this.logName(), service);
        this.retrievedSchemaContext(((DOMSchemaService)service).getGlobalContext());
    }

    private void retrievedSchemaContext(SchemaContext schemaContext) {
        this.log.debug("{}: retrievedSchemaContext", (Object)this.logName());
        Collection<SchemaPath> schemaPaths = RpcUtil.decomposeRpcService(this.rpcInterface, schemaContext, this.rpcFilter());
        if (schemaPaths.isEmpty()) {
            this.log.debug("{}: interface {} has no acceptable entries, assuming it is satisfied", (Object)this.logName(), this.rpcInterface);
            this.setSatisfied();
            return;
        }
        this.rpcSchemaPaths = ImmutableSet.copyOf(schemaPaths);
        this.log.debug("{}: Got SchemaPaths: {}", (Object)this.logName(), this.rpcSchemaPaths);
        this.retrieveService("DOMRpcService", DOMRpcService.class, this::retrievedDOMRpcService);
    }

    private void retrievedDOMRpcService(Object service) {
        this.log.debug("{}: retrievedDOMRpcService {}", (Object)this.logName(), service);
        DOMRpcService domRpcService = (DOMRpcService)service;
        this.setDependencyDesc("Available DOM RPC for binding RPC: " + this.rpcInterface);
        this.rpcListenerReg = domRpcService.registerRpcListener(new DOMRpcAvailabilityListener(){

            public void onRpcAvailable(Collection<DOMRpcIdentifier> rpcs) {
                AbstractInvokableServiceMetadata.this.onRpcsAvailable(rpcs);
            }

            public void onRpcUnavailable(Collection<DOMRpcIdentifier> rpcs) {
            }
        });
    }

    abstract Predicate<RpcRoutingStrategy> rpcFilter();

    public final Object create() throws ComponentDefinitionException {
        this.log.debug("{}: In create: interfaceName: {}", (Object)this.logName(), (Object)this.interfaceName);
        super.onCreate();
        try {
            RpcService rpcService = this.rpcRegistry.getRpcService(this.rpcInterface);
            this.log.debug("{}: create returning service {}", (Object)this.logName(), (Object)rpcService);
            return rpcService;
        }
        catch (RuntimeException e) {
            throw new ComponentDefinitionException("Error getting RPC service for " + this.interfaceName, (Throwable)e);
        }
    }

    protected final void onRpcsAvailable(Collection<DOMRpcIdentifier> rpcs) {
        for (DOMRpcIdentifier identifier : rpcs) {
            if (!this.rpcSchemaPaths.contains(identifier.getType())) continue;
            this.log.debug("{}: onRpcsAvailable - found SchemaPath {}", (Object)this.logName(), (Object)identifier.getType());
            this.setSatisfied();
            break;
        }
    }

    @Override
    public final void stopTracking() {
        super.stopTracking();
        this.closeRpcListenerReg();
    }

    private void closeRpcListenerReg() {
        if (this.rpcListenerReg != null) {
            this.rpcListenerReg.close();
            this.rpcListenerReg = null;
        }
    }

    @Override
    public final void destroy(Object instance) {
        super.destroy(instance);
        this.closeRpcListenerReg();
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("interfaceName", (Object)this.interfaceName).toString();
    }
}

