/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.blueprint.ext;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import org.apache.aries.blueprint.di.AbstractRecipe;
import org.apache.aries.blueprint.di.ExecutionContext;
import org.apache.aries.blueprint.di.Recipe;
import org.apache.aries.blueprint.ext.DependentComponentFactoryMetadata;
import org.apache.aries.blueprint.services.ExtendedBlueprintContainer;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.blueprint.BlueprintContainerRestartService;
import org.opendaylight.controller.blueprint.ext.StaticServiceReferenceRecipe;
import org.osgi.framework.ServiceReference;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDependentComponentFactoryMetadata
implements DependentComponentFactoryMetadata {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String id;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean satisfied = new AtomicBoolean();
    private final AtomicBoolean restarting = new AtomicBoolean();
    @GuardedBy(value="serviceRecipes")
    private final List<StaticServiceReferenceRecipe> serviceRecipes = new ArrayList<StaticServiceReferenceRecipe>();
    private volatile ExtendedBlueprintContainer container;
    private volatile DependentComponentFactoryMetadata.SatisfactionCallback satisfactionCallback;
    private volatile String failureMessage;
    private volatile Throwable failureCause;
    private volatile String dependencyDesc;
    @GuardedBy(value="serviceRecipes")
    private boolean stoppedServiceRecipes;

    protected AbstractDependentComponentFactoryMetadata(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
    }

    public String getId() {
        return this.id;
    }

    public int getActivation() {
        return 1;
    }

    public List<String> getDependsOn() {
        return Collections.emptyList();
    }

    public String getDependencyDescriptor() {
        return this.dependencyDesc;
    }

    public boolean isSatisfied() {
        return this.satisfied.get();
    }

    protected void setFailureMessage(String failureMessage) {
        this.setFailure(failureMessage, null);
    }

    protected void setFailure(String failureMessage, Throwable failureCause) {
        this.failureMessage = failureMessage;
        this.failureCause = failureCause;
    }

    protected void setDependencyDesc(String dependencyDesc) {
        this.dependencyDesc = dependencyDesc;
    }

    protected final ExtendedBlueprintContainer container() {
        return this.container;
    }

    protected void setSatisfied() {
        if (this.satisfied.compareAndSet(false, true)) {
            this.satisfactionCallback.notifyChanged();
        }
    }

    protected void retrieveService(String name, Class<?> interfaceClass, Consumer<Object> onServiceRetrieved) {
        this.retrieveService(name, interfaceClass.getName(), onServiceRetrieved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieveService(String name, String interfaceName, Consumer<Object> onServiceRetrieved) {
        List<StaticServiceReferenceRecipe> list = this.serviceRecipes;
        synchronized (list) {
            if (this.stoppedServiceRecipes) {
                return;
            }
            StaticServiceReferenceRecipe recipe = new StaticServiceReferenceRecipe(this.getId() + "-" + name, this.container, interfaceName);
            this.setDependencyDesc(recipe.getOsgiFilter());
            this.serviceRecipes.add(recipe);
            recipe.startTracking(onServiceRetrieved);
        }
    }

    protected final String logName() {
        return (this.container != null ? this.container.getBundleContext().getBundle().getSymbolicName() : "") + " (" + this.id + ")";
    }

    public void init(ExtendedBlueprintContainer newContainer) {
        this.container = newContainer;
        this.log.debug("{}: In init", (Object)this.logName());
    }

    protected void onCreate() throws ComponentDefinitionException {
        if (this.failureMessage != null) {
            throw new ComponentDefinitionException(this.failureMessage, this.failureCause);
        }
        ExecutionContext executionContext = ExecutionContext.Holder.getContext();
        executionContext.removePartialObject(this.id);
        Recipe myRecipe = executionContext.getRecipe(this.id);
        if (myRecipe instanceof AbstractRecipe) {
            this.log.debug("{}: setPrototype to false", (Object)this.logName());
            ((AbstractRecipe)myRecipe).setPrototype(false);
        } else {
            this.log.warn("{}: Recipe is null or not an AbstractRecipe", (Object)this.logName());
        }
    }

    protected abstract void startTracking();

    public final void startTracking(DependentComponentFactoryMetadata.SatisfactionCallback newSatisfactionCallback) {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.log.debug("{}: In startTracking", (Object)this.logName());
        this.satisfactionCallback = newSatisfactionCallback;
        this.startTracking();
    }

    public void stopTracking() {
        this.log.debug("{}: In stopTracking", (Object)this.logName());
        this.stopServiceRecipes();
    }

    public void destroy(Object instance) {
        this.log.debug("{}: In destroy", (Object)this.logName());
        this.stopServiceRecipes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServiceRecipes() {
        List<StaticServiceReferenceRecipe> list = this.serviceRecipes;
        synchronized (list) {
            this.stoppedServiceRecipes = true;
            for (StaticServiceReferenceRecipe recipe : this.serviceRecipes) {
                recipe.stop();
            }
            this.serviceRecipes.clear();
        }
    }

    protected void restartContainer() {
        BlueprintContainerRestartService restartService;
        if (this.restarting.compareAndSet(false, true) && (restartService = this.getOSGiService(BlueprintContainerRestartService.class)) != null) {
            this.log.debug("{}: Restarting container", (Object)this.logName());
            restartService.restartContainerAndDependents(this.container().getBundleContext().getBundle());
        }
    }

    protected <T> @Nullable T getOSGiService(Class<T> serviceInterface) {
        try {
            ServiceReference serviceReference = this.container().getBundleContext().getServiceReference(serviceInterface);
            if (serviceReference == null) {
                this.log.warn("{}: {} reference not found", (Object)this.logName(), (Object)serviceInterface.getSimpleName());
                return null;
            }
            Object service = this.container().getService(serviceReference);
            if (service == null) {
                this.log.debug("{}: {} was not found", (Object)this.logName(), (Object)serviceInterface.getSimpleName());
            }
            return (T)service;
        }
        catch (IllegalStateException e) {
            this.log.debug("{}: Error obtaining {}", new Object[]{this.logName(), serviceInterface.getSimpleName(), e});
            return null;
        }
    }
}

