/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransactionImpl;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransactionImpl;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

@Deprecated
public final class TransactionAdapter {
    private TransactionAdapter() {
    }

    public static ReadWriteTransaction toReadWriteTransaction(TypedReadWriteTransaction<? extends Datastore> datastoreTx) {
        if (datastoreTx instanceof TypedReadWriteTransactionImpl) {
            TypedReadWriteTransactionImpl txImpl = (TypedReadWriteTransactionImpl)datastoreTx;
            return new ReadWriteTransactionAdapter(txImpl.getDatastoreType(), txImpl);
        }
        throw new IllegalArgumentException("Unsupported TypedWriteTransaction implementation " + datastoreTx.getClass());
    }

    public static WriteTransaction toWriteTransaction(TypedWriteTransaction<? extends Datastore> datastoreTx) {
        if (datastoreTx instanceof TypedWriteTransactionImpl) {
            TypedWriteTransactionImpl txImpl = (TypedWriteTransactionImpl)datastoreTx;
            return new WriteTransactionAdapter(txImpl.getDatastoreType(), txImpl);
        }
        throw new IllegalArgumentException("Unsupported TypedWriteTransaction implementation " + datastoreTx.getClass());
    }

    private static final class ReadWriteTransactionAdapter<S extends Datastore>
    extends WriteTransactionAdapter<S, TypedReadWriteTransaction<S>>
    implements ReadWriteTransaction {
        ReadWriteTransactionAdapter(LogicalDatastoreType datastoreType, TypedReadWriteTransaction<S> delegate) {
            super(datastoreType, delegate);
        }

        public <T extends DataObject> FluentFuture<Optional<T>> read(LogicalDatastoreType store, InstanceIdentifier<T> path) {
            this.checkStore(store);
            return ((TypedReadWriteTransaction)this.delegate()).read(path);
        }

        public FluentFuture<Boolean> exists(LogicalDatastoreType store, InstanceIdentifier<?> path) {
            this.checkStore(store);
            return ((TypedReadWriteTransaction)this.delegate()).exists(path);
        }
    }

    private static class WriteTransactionAdapter<S extends Datastore, D extends TypedWriteTransaction<S>>
    extends ForwardingObject
    implements WriteTransaction {
        private final LogicalDatastoreType datastoreType;
        private final D delegate;

        WriteTransactionAdapter(LogicalDatastoreType datastoreType, D delegate) {
            this.datastoreType = datastoreType;
            this.delegate = delegate;
        }

        public <T extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
            this.checkStore(store);
            this.delegate.put(path, data);
        }

        @Deprecated
        public <T extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<T> path, T data, boolean createMissingParents) {
            this.checkStore(store);
            this.delegate.put(path, data, createMissingParents);
        }

        public <T extends DataObject> void mergeParentStructurePut(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
            this.checkStore(store);
            this.delegate.mergeParentStructurePut(path, data);
        }

        public <T extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
            this.checkStore(store);
            this.delegate.merge(path, data);
        }

        @Deprecated
        public <T extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data, boolean createMissingParents) {
            this.checkStore(store);
            this.delegate.merge(path, data, createMissingParents);
        }

        public <T extends DataObject> void mergeParentStructureMerge(LogicalDatastoreType store, InstanceIdentifier<T> path, T data) {
            this.checkStore(store);
            this.delegate.mergeParentStructureMerge(path, data);
        }

        public boolean cancel() {
            throw new UnsupportedOperationException("Managed transactions must not be cancelled");
        }

        public void delete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
            this.checkStore(store);
            this.delegate.delete(path);
        }

        public @NonNull FluentFuture<? extends CommitInfo> commit() {
            throw new UnsupportedOperationException("Managed transactions must not be committed");
        }

        public Object getIdentifier() {
            return this.delegate.getIdentifier();
        }

        protected D delegate() {
            return this.delegate;
        }

        void checkStore(LogicalDatastoreType store) {
            Preconditions.checkArgument((boolean)this.datastoreType.equals((Object)store), (String)"Invalid datastore %s used instead of %s", (Object)store, (Object)this.datastoreType);
        }
    }
}

