/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.binding.api.TransactionFactory;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.util.CheckedConsumer;
import org.opendaylight.mdsal.binding.util.CheckedFunction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedConsumer;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedFunction;
import org.opendaylight.mdsal.binding.util.ManagedTransactionFactory;
import org.opendaylight.mdsal.binding.util.TypedReadTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadTransactionImpl;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransactionImpl;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransactionImpl;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManagedTransactionFactoryImpl<T extends TransactionFactory>
implements ManagedTransactionFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ManagedTransactionFactoryImpl.class);
    private final T transactionFactory;

    ManagedTransactionFactoryImpl(T transactionFactory) {
        this.transactionFactory = (TransactionFactory)Objects.requireNonNull(transactionFactory, "transactionFactory must not be null");
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public <D extends Datastore, E extends Exception, R> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E, InterruptedException {
        try (ReadTransaction realTx = this.transactionFactory.newReadOnlyTransaction();){
            TypedReadTransactionImpl<D> wrappedTx = new TypedReadTransactionImpl<D>(datastoreType, realTx);
            R r = txFunction.apply(wrappedTx);
            return r;
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public <D extends Datastore, E extends Exception, R> R applyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E {
        try (ReadTransaction realTx = this.transactionFactory.newReadOnlyTransaction();){
            TypedReadTransactionImpl<D> wrappedTx = new TypedReadTransactionImpl<D>(datastoreType, realTx);
            R r = txFunction.apply(wrappedTx);
            return r;
        }
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txFunction) {
        return this.applyWithNewTransactionAndSubmit(datastoreType, () -> this.transactionFactory.newReadWriteTransaction(), TypedReadWriteTransactionImpl::new, txFunction, (realTx, wrappedTx) -> realTx.commit());
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E, InterruptedException {
        try (ReadTransaction realTx = this.transactionFactory.newReadOnlyTransaction();){
            TypedReadTransactionImpl<D> wrappedTx = new TypedReadTransactionImpl<D>(datastoreType, realTx);
            txConsumer.accept(wrappedTx);
        }
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(Class<D> datastoreType, CheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E {
        try (ReadTransaction realTx = this.transactionFactory.newReadOnlyTransaction();){
            TypedReadTransactionImpl<D> wrappedTx = new TypedReadTransactionImpl<D>(datastoreType, realTx);
            txConsumer.accept(wrappedTx);
        }
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewReadWriteTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewTransactionAndSubmit(datastoreType, () -> this.transactionFactory.newReadWriteTransaction(), TypedReadWriteTransactionImpl::new, txConsumer, (realTx, wrappedTx) -> realTx.commit());
    }

    @Override
    @CheckReturnValue
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewWriteOnlyTransactionAndSubmit(Class<D> datastoreType, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewTransactionAndSubmit(datastoreType, () -> this.transactionFactory.newWriteOnlyTransaction(), TypedWriteTransactionImpl::new, txConsumer, (realTx, wrappedTx) -> realTx.commit());
    }

    @CheckReturnValue
    protected <D extends Datastore, X extends WriteTransaction, W, E extends Exception> FluentFuture<? extends Object> callWithNewTransactionAndSubmit(Class<D> datastoreType, Supplier<X> txSupplier, BiFunction<Class<D>, X, W> txWrapper, InterruptibleCheckedConsumer<W, E> txConsumer, BiFunction<X, W, FluentFuture<?>> txSubmitter) {
        return this.applyWithNewTransactionAndSubmit(datastoreType, txSupplier, txWrapper, tx -> {
            txConsumer.accept(tx);
            return null;
        }, txSubmitter);
    }

    @CheckReturnValue
    protected <D extends Datastore, X extends WriteTransaction, W, R, E extends Exception> FluentFuture<R> applyWithNewTransactionAndSubmit(Class<D> datastoreType, Supplier<X> txSupplier, BiFunction<Class<D>, X, W> txWrapper, InterruptibleCheckedFunction<W, R, E> txFunction, BiFunction<X, W, FluentFuture<?>> txSubmitter) {
        Object result;
        WriteTransaction realTx = (WriteTransaction)txSupplier.get();
        W wrappedTx = txWrapper.apply(datastoreType, realTx);
        try {
            result = txFunction.apply(wrappedTx);
        }
        catch (Exception e) {
            if (!realTx.cancel()) {
                LOG.error("Transaction.cancel() returned false - this should never happen (here)");
            }
            return FluentFutures.immediateFailedFluentFuture((Throwable)e);
        }
        return txSubmitter.apply(realTx, wrappedTx).transform(v -> result, MoreExecutors.directExecutor());
    }

    protected T getTransactionFactory() {
        return this.transactionFactory;
    }
}

