/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.MalformedJsonException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.odlext.model.api.YangModeledAnyXmlSchemaNode;
import org.opendaylight.yangtools.util.xml.UntrustedXML;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.util.AbstractNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.AnyXmlNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.LeafNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.OperationAsContainer;
import org.opendaylight.yangtools.yang.data.util.ParserStreamUtils;
import org.opendaylight.yangtools.yang.data.util.SimpleNodeDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

@Beta
public final class JsonParserStream
implements Closeable,
Flushable {
    static final String ANYXML_ARRAY_ELEMENT_ID = "array-element";
    private final Deque<URI> namespaces = new ArrayDeque<URI>();
    private final NormalizedNodeStreamWriter writer;
    private final JSONCodecFactory codecs;
    private final DataSchemaNode parentNode;

    private JsonParserStream(NormalizedNodeStreamWriter writer, JSONCodecFactory codecs, DataSchemaNode parentNode) {
        this.writer = Objects.requireNonNull(writer);
        this.codecs = Objects.requireNonNull(codecs);
        this.parentNode = parentNode;
    }

    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory) {
        return new JsonParserStream(writer, codecFactory, (DataSchemaNode)codecFactory.getSchemaContext());
    }

    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull JSONCodecFactory codecFactory, @NonNull SchemaNode parentNode) {
        DataSchemaNode parent;
        if (parentNode instanceof DataSchemaNode) {
            parent = (DataSchemaNode)parentNode;
        } else if (parentNode instanceof OperationDefinition) {
            parent = OperationAsContainer.of((OperationDefinition)((OperationDefinition)parentNode));
        } else {
            throw new IllegalArgumentException("Illegal parent node " + Objects.requireNonNull(parentNode));
        }
        return new JsonParserStream(writer, codecFactory, parent);
    }

    @Deprecated
    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull SchemaContext schemaContext) {
        return JsonParserStream.create(writer, JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(schemaContext));
    }

    @Deprecated
    public static @NonNull JsonParserStream create(@NonNull NormalizedNodeStreamWriter writer, @NonNull SchemaContext schemaContext, @NonNull SchemaNode parentNode) {
        return JsonParserStream.create(writer, JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(schemaContext), parentNode);
    }

    public JsonParserStream parse(JsonReader reader) {
        boolean lenient = reader.isLenient();
        reader.setLenient(true);
        boolean isEmpty = true;
        try {
            reader.peek();
            isEmpty = false;
            CompositeNodeDataWithSchema compositeNodeDataWithSchema = new CompositeNodeDataWithSchema(this.parentNode);
            this.read(reader, (AbstractNodeDataWithSchema)compositeNodeDataWithSchema);
            compositeNodeDataWithSchema.write(this.writer);
            JsonParserStream jsonParserStream = this;
            return jsonParserStream;
        }
        catch (EOFException e) {
            if (isEmpty) {
                JsonParserStream jsonParserStream = this;
                return jsonParserStream;
            }
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (MalformedJsonException | NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (OutOfMemoryError | StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)e);
        }
        finally {
            reader.setLenient(lenient);
        }
    }

    private void traverseAnyXmlValue(JsonReader in, Document doc, Element parentElement) throws IOException {
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                Text textNode = doc.createTextNode(in.nextString());
                parentElement.appendChild(textNode);
                break;
            }
            case BOOLEAN: {
                Text textNode = doc.createTextNode(Boolean.toString(in.nextBoolean()));
                parentElement.appendChild(textNode);
                break;
            }
            case NULL: {
                in.nextNull();
                Text textNode = doc.createTextNode("null");
                parentElement.appendChild(textNode);
                break;
            }
            case BEGIN_ARRAY: {
                in.beginArray();
                while (in.hasNext()) {
                    Element childElement = doc.createElement(ANYXML_ARRAY_ELEMENT_ID);
                    parentElement.appendChild(childElement);
                    this.traverseAnyXmlValue(in, doc, childElement);
                }
                in.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                in.beginObject();
                while (in.hasNext()) {
                    Element childElement = doc.createElement(in.nextName());
                    parentElement.appendChild(childElement);
                    this.traverseAnyXmlValue(in, doc, childElement);
                }
                in.endObject();
                break;
            }
        }
    }

    private void readAnyXmlValue(JsonReader in, AnyXmlNodeDataWithSchema parent, String anyXmlObjectName) throws IOException {
        String anyXmlObjectNS = this.getCurrentNamespace().toString();
        Document doc = UntrustedXML.newDocumentBuilder().newDocument();
        Element rootElement = doc.createElementNS(anyXmlObjectNS, anyXmlObjectName);
        doc.appendChild(rootElement);
        this.traverseAnyXmlValue(in, doc, rootElement);
        DOMSource domSource = new DOMSource(doc.getDocumentElement());
        parent.setValue((Object)domSource);
    }

    public void read(JsonReader in, AbstractNodeDataWithSchema parent) throws IOException {
        switch (in.peek()) {
            case STRING: 
            case NUMBER: {
                this.setValue(parent, in.nextString());
                break;
            }
            case BOOLEAN: {
                this.setValue(parent, Boolean.toString(in.nextBoolean()));
                break;
            }
            case NULL: {
                in.nextNull();
                this.setValue(parent, null);
                break;
            }
            case BEGIN_ARRAY: {
                in.beginArray();
                while (in.hasNext()) {
                    if (parent instanceof LeafNodeDataWithSchema) {
                        this.read(in, parent);
                        continue;
                    }
                    AbstractNodeDataWithSchema newChild = JsonParserStream.newArrayEntry(parent);
                    this.read(in, newChild);
                }
                in.endArray();
                return;
            }
            case BEGIN_OBJECT: {
                HashSet<String> namesakes = new HashSet<String>();
                in.beginObject();
                if (JsonParserStream.isArray(parent)) {
                    parent = JsonParserStream.newArrayEntry(parent);
                }
                while (in.hasNext()) {
                    String jsonElementName = in.nextName();
                    DataSchemaNode parentSchema = parent.getSchema();
                    if (parentSchema instanceof YangModeledAnyXmlSchemaNode) {
                        parentSchema = ((YangModeledAnyXmlSchemaNode)parentSchema).getSchemaOfAnyXmlData();
                    }
                    Map.Entry<String, URI> namespaceAndName = this.resolveNamespace(jsonElementName, parentSchema);
                    String localName = namespaceAndName.getKey();
                    this.addNamespace(namespaceAndName.getValue());
                    if (!namesakes.add(jsonElementName)) {
                        throw new JsonSyntaxException("Duplicate name " + jsonElementName + " in JSON input.");
                    }
                    Deque childDataSchemaNodes = ParserStreamUtils.findSchemaNodeByNameAndNamespace((DataSchemaNode)parentSchema, (String)localName, (URI)this.getCurrentNamespace());
                    Preconditions.checkState((!childDataSchemaNodes.isEmpty() ? 1 : 0) != 0, (String)"Schema for node with name %s and namespace %s does not exist at %s", (Object)localName, (Object)this.getCurrentNamespace(), (Object)parentSchema.getPath());
                    AbstractNodeDataWithSchema newChild = ((CompositeNodeDataWithSchema)parent).addChild(childDataSchemaNodes);
                    if (newChild instanceof AnyXmlNodeDataWithSchema) {
                        this.readAnyXmlValue(in, (AnyXmlNodeDataWithSchema)newChild, jsonElementName);
                    } else {
                        this.read(in, newChild);
                    }
                    this.removeNamespace();
                }
                in.endObject();
                return;
            }
        }
    }

    private static boolean isArray(AbstractNodeDataWithSchema parent) {
        return parent instanceof ListNodeDataWithSchema || parent instanceof LeafListNodeDataWithSchema;
    }

    private static AbstractNodeDataWithSchema newArrayEntry(AbstractNodeDataWithSchema parent) {
        ListEntryNodeDataWithSchema newChild;
        if (parent instanceof ListNodeDataWithSchema) {
            newChild = new ListEntryNodeDataWithSchema(parent.getSchema());
        } else if (parent instanceof LeafListNodeDataWithSchema) {
            newChild = new LeafListEntryNodeDataWithSchema(parent.getSchema());
        } else {
            throw new IllegalStateException("Found an unexpected array nested under " + parent.getSchema().getQName());
        }
        ((CompositeNodeDataWithSchema)parent).addChild((AbstractNodeDataWithSchema)newChild);
        return newChild;
    }

    private void setValue(AbstractNodeDataWithSchema parent, String value) {
        Preconditions.checkArgument((boolean)(parent instanceof SimpleNodeDataWithSchema), (String)"Node %s is not a simple type", (Object)parent.getSchema().getQName());
        SimpleNodeDataWithSchema parentSimpleNode = (SimpleNodeDataWithSchema)parent;
        Preconditions.checkArgument((parentSimpleNode.getValue() == null ? 1 : 0) != 0, (String)"Node '%s' has already set its value to '%s'", (Object)parentSimpleNode.getSchema().getQName(), (Object)parentSimpleNode.getValue());
        Object translatedValue = this.translateValueByType(value, parentSimpleNode.getSchema());
        parentSimpleNode.setValue(translatedValue);
    }

    private Object translateValueByType(String value, DataSchemaNode node) {
        Preconditions.checkArgument((boolean)(node instanceof TypedDataSchemaNode));
        return ((JSONCodec)this.codecs.codecFor((TypedDataSchemaNode)node)).parseValue(null, value);
    }

    private void removeNamespace() {
        this.namespaces.pop();
    }

    private void addNamespace(URI namespace) {
        this.namespaces.push(namespace);
    }

    private Map.Entry<String, URI> resolveNamespace(String childName, DataSchemaNode dataSchemaNode) {
        int lastIndexOfColon = childName.lastIndexOf(58);
        String moduleNamePart = null;
        String nodeNamePart = null;
        URI namespace = null;
        if (lastIndexOfColon != -1) {
            moduleNamePart = childName.substring(0, lastIndexOfColon);
            nodeNamePart = childName.substring(lastIndexOfColon + 1);
            Iterator m = this.codecs.getSchemaContext().findModules(moduleNamePart).iterator();
            namespace = m.hasNext() ? ((Module)m.next()).getNamespace() : null;
        } else {
            nodeNamePart = childName;
        }
        if (namespace == null) {
            Set<URI> potentialUris = this.resolveAllPotentialNamespaces(nodeNamePart, dataSchemaNode);
            if (potentialUris.contains(this.getCurrentNamespace())) {
                namespace = this.getCurrentNamespace();
            } else if (potentialUris.size() == 1) {
                namespace = potentialUris.iterator().next();
            } else {
                if (potentialUris.size() > 1) {
                    throw new IllegalStateException("Choose suitable module name for element " + nodeNamePart + ":" + this.toModuleNames(potentialUris));
                }
                if (potentialUris.isEmpty()) {
                    throw new IllegalStateException("Schema node with name " + nodeNamePart + " was not found under " + dataSchemaNode.getQName() + ".");
                }
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(nodeNamePart, namespace);
    }

    private String toModuleNames(Set<URI> potentialUris) {
        StringBuilder builder = new StringBuilder();
        for (URI potentialUri : potentialUris) {
            builder.append('\n');
            builder.append(((Module)this.codecs.getSchemaContext().findModules(potentialUri).iterator().next()).getName());
        }
        return builder.toString();
    }

    private Set<URI> resolveAllPotentialNamespaces(String elementName, DataSchemaNode dataSchemaNode) {
        HashSet<URI> potentialUris = new HashSet<URI>();
        HashSet<ChoiceSchemaNode> choices = new HashSet<ChoiceSchemaNode>();
        if (dataSchemaNode instanceof DataNodeContainer) {
            for (DataSchemaNode childSchemaNode : ((DataNodeContainer)dataSchemaNode).getChildNodes()) {
                if (childSchemaNode instanceof ChoiceSchemaNode) {
                    choices.add((ChoiceSchemaNode)childSchemaNode);
                    continue;
                }
                if (!childSchemaNode.getQName().getLocalName().equals(elementName)) continue;
                potentialUris.add(childSchemaNode.getQName().getNamespace());
            }
            for (ChoiceSchemaNode choiceNode : choices) {
                for (CaseSchemaNode concreteCase : choiceNode.getCases().values()) {
                    potentialUris.addAll(this.resolveAllPotentialNamespaces(elementName, (DataSchemaNode)concreteCase));
                }
            }
        }
        return potentialUris;
    }

    private URI getCurrentNamespace() {
        return this.namespaces.peek();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

