/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

abstract class JSONStreamWriterContext {
    private final JSONStreamWriterContext parent;
    private final boolean mandatory;
    private final int depth;
    private boolean emittedMyself = false;

    protected JSONStreamWriterContext(JSONStreamWriterContext parent, boolean mandatory) {
        this.mandatory = mandatory;
        this.parent = parent;
        this.depth = parent != null ? parent.depth + 1 : 0;
    }

    final void writeChildJsonIdentifier(SchemaContext schema, JsonWriter writer, QName qname) throws IOException {
        StringBuilder sb = new StringBuilder();
        QNameModule module = qname.getModule();
        if (!module.getNamespace().equals(this.getNamespace())) {
            Optional<String> modules = schema.findModule(module).map(Module::getName);
            Preconditions.checkArgument((boolean)modules.isPresent(), (String)"Could not find module for namespace {}", (Object)module);
            sb.append(modules.get()).append(':');
        }
        sb.append(qname.getLocalName());
        writer.name(sb.toString());
    }

    protected final void writeMyJsonIdentifier(SchemaContext schema, JsonWriter writer, QName qname) throws IOException {
        this.parent.writeChildJsonIdentifier(schema, writer, qname);
    }

    protected abstract @NonNull URI getNamespace();

    protected abstract void emitStart(SchemaContext var1, JsonWriter var2) throws IOException;

    protected abstract void emitEnd(JsonWriter var1) throws IOException;

    private void emitMyself(SchemaContext schema, JsonWriter writer) throws IOException {
        if (!this.emittedMyself) {
            if (this.parent != null) {
                this.parent.emittingChild(schema, writer);
            }
            this.emitStart(schema, writer);
            this.emittedMyself = true;
        }
    }

    final void emittingChild(SchemaContext schema, JsonWriter writer) throws IOException {
        this.emitMyself(schema, writer);
    }

    final JSONStreamWriterContext endNode(SchemaContext schema, JsonWriter writer) throws IOException {
        if (!this.emittedMyself && this.mandatory) {
            this.emitMyself(schema, writer);
        }
        if (this.emittedMyself) {
            this.emitEnd(writer);
        }
        return this.parent;
    }
}

