/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.RFC7951JSONInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.LazyCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.NoopCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.PrecomputedCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.SharedCodecCache;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public enum JSONCodecFactorySupplier {
    RFC7951(RFC7951JSONInstanceIdentifierCodec::new),
    DRAFT_LHOTKA_NETMOD_YANG_JSON_02(JSONInstanceIdentifierCodec::new);

    private static final Logger LOG;
    private final BiFunction<SchemaContext, JSONCodecFactory, JSONInstanceIdentifierCodec> iidCodecSupplier;
    private final LoadingCache<SchemaContext, JSONCodecFactory> precomputed;
    private final LoadingCache<SchemaContext, JSONCodecFactory> shared;

    private JSONCodecFactorySupplier(final BiFunction<SchemaContext, JSONCodecFactory, JSONInstanceIdentifierCodec> iidCodecSupplier) {
        this.iidCodecSupplier = Objects.requireNonNull(iidCodecSupplier);
        this.precomputed = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new EagerCacheLoader(iidCodecSupplier));
        this.shared = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<SchemaContext, JSONCodecFactory>(){

            public JSONCodecFactory load(SchemaContext key) {
                return new JSONCodecFactory(key, (CodecCache<JSONCodec<?>>)new SharedCodecCache(), iidCodecSupplier);
            }
        });
    }

    public @NonNull JSONCodecFactory getPrecomputed(@NonNull SchemaContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)this.precomputed.getUnchecked((Object)context)));
    }

    public @NonNull Optional<JSONCodecFactory> getPrecomputedIfAvailable(@NonNull SchemaContext context) {
        return Optional.ofNullable(this.precomputed.getIfPresent((Object)context));
    }

    public @NonNull JSONCodecFactory getShared(@NonNull SchemaContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)this.shared.getUnchecked((Object)context)));
    }

    public @NonNull JSONCodecFactory createLazy(@NonNull SchemaContext context) {
        return new JSONCodecFactory(context, (CodecCache<JSONCodec<?>>)new LazyCodecCache(), this.iidCodecSupplier);
    }

    public @NonNull JSONCodecFactory createSimple(@NonNull SchemaContext context) {
        return new JSONCodecFactory(context, (CodecCache<JSONCodec<?>>)NoopCodecCache.getInstance(), this.iidCodecSupplier);
    }

    static {
        LOG = LoggerFactory.getLogger(JSONCodecFactorySupplier.class);
    }

    private static final class EagerCacheLoader
    extends CacheLoader<SchemaContext, JSONCodecFactory> {
        private final BiFunction<SchemaContext, JSONCodecFactory, JSONInstanceIdentifierCodec> iidCodecSupplier;

        EagerCacheLoader(BiFunction<SchemaContext, JSONCodecFactory, JSONInstanceIdentifierCodec> iidCodecSupplier) {
            this.iidCodecSupplier = Objects.requireNonNull(iidCodecSupplier);
        }

        public JSONCodecFactory load(SchemaContext key) {
            Stopwatch sw = Stopwatch.createStarted();
            LazyCodecCache lazyCache = new LazyCodecCache();
            JSONCodecFactory lazy = new JSONCodecFactory(key, (CodecCache<JSONCodec<?>>)lazyCache, this.iidCodecSupplier);
            int visitedLeaves = EagerCacheLoader.requestCodecsForChildren(lazy, (DataNodeContainer)key);
            sw.stop();
            PrecomputedCodecCache cache = lazyCache.toPrecomputed();
            LOG.debug("{} leaf nodes resulted in {} simple and {} complex codecs in {}", new Object[]{visitedLeaves, cache.simpleSize(), cache.complexSize(), sw});
            return new JSONCodecFactory(key, (CodecCache<JSONCodec<?>>)cache, this.iidCodecSupplier);
        }

        private static int requestCodecsForChildren(JSONCodecFactory lazy, DataNodeContainer parent) {
            int ret = 0;
            for (DataSchemaNode child : parent.getChildNodes()) {
                if (child instanceof TypedDataSchemaNode) {
                    lazy.codecFor((TypedDataSchemaNode)child);
                    ++ret;
                    continue;
                }
                if (!(child instanceof DataNodeContainer)) continue;
                ret += EagerCacheLoader.requestCodecsForChildren(lazy, (DataNodeContainer)child);
            }
            return ret;
        }
    }
}

