/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.model.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationStatement;
import org.opendaylight.yangtools.rfc7952.model.api.MetadataConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@NonNullByDefault
public enum MetadataStatements implements StatementDefinition
{
    ANNOTATION(QName.create((QNameModule)MetadataConstants.RFC7952_MODULE, (String)"annotation"), "name", AnnotationStatement.class, AnnotationEffectiveStatement.class);

    private final Class<? extends EffectiveStatement<?, ?>> effectiveRepresentation;
    private final Class<? extends DeclaredStatement<?>> declaredRepresentation;
    private final QName statementName;
    private final QName argumentName;

    private MetadataStatements(QName statementName, String argumentName, Class<? extends DeclaredStatement<?>> declaredRepresentation, Class<? extends EffectiveStatement<?, ?>> effectiveRepresentation) {
        this.statementName = statementName.intern();
        this.argumentName = QName.create((QName)statementName, (String)argumentName);
        this.declaredRepresentation = Objects.requireNonNull(declaredRepresentation);
        this.effectiveRepresentation = Objects.requireNonNull(effectiveRepresentation);
    }

    public @NonNull QName getArgumentName() {
        return this.argumentName;
    }

    public boolean isArgumentYinElement() {
        return false;
    }

    public QName getStatementName() {
        return this.statementName;
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveRepresentation;
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.declaredRepresentation;
    }
}

